/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.Handle;
import bending.libraries.jdbi.v3.core.result.ResultBearing;
import bending.libraries.jdbi.v3.core.result.ResultProducer;
import bending.libraries.jdbi.v3.core.result.ResultProducers;
import bending.libraries.jdbi.v3.core.result.ResultSetScanner;
import bending.libraries.jdbi.v3.core.result.UnableToProduceResultException;
import bending.libraries.jdbi.v3.core.statement.SqlStatement;
import bending.libraries.jdbi.v3.core.statement.StatementCustomizers;
import java.sql.SQLException;

public class Query
extends SqlStatement<Query>
implements ResultBearing {
    public Query(Handle handle, CharSequence sql) {
        super(handle, sql);
    }

    public Query(Handle handle, String sql) {
        super(handle, sql);
    }

    public <R> R execute(ResultProducer<R> producer) {
        try {
            return producer.produce(this::internalExecute, this.getContext());
        }
        catch (SQLException e) {
            this.cleanUpForException(e);
            throw new UnableToProduceResultException(e, this.getContext());
        }
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(resultSetScanner);
    }

    public Query setFetchSize(int fetchSize) {
        return (Query)this.addCustomizer(StatementCustomizers.fetchSize(fetchSize));
    }

    public Query setMaxRows(int maxRows) {
        return (Query)this.addCustomizer(StatementCustomizers.maxRows(maxRows));
    }

    public Query setMaxFieldSize(int maxFields) {
        return (Query)this.addCustomizer(StatementCustomizers.maxFieldSize(maxFields));
    }

    public Query concurrentUpdatable() {
        this.getContext().setConcurrentUpdatable(true);
        return this;
    }
}

