/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.Handle;
import bending.libraries.jdbi.v3.core.inlined.org.antlr.v4.runtime.$CharStreams;
import bending.libraries.jdbi.v3.core.internal.SqlScriptParser;
import bending.libraries.jdbi.v3.core.statement.Batch;
import bending.libraries.jdbi.v3.core.statement.SqlStatement;
import bending.libraries.jdbi.v3.core.statement.SqlStatements;
import bending.libraries.jdbi.v3.core.statement.TemplateEngine;
import java.util.List;

public class Script
extends SqlStatement<Script> {
    private final boolean requireSemicolon;

    public Script(Handle handle, CharSequence sql) {
        super(handle, sql);
        this.requireSemicolon = handle.getConfig(SqlStatements.class).isScriptStatementsNeedSemicolon();
    }

    public Script(Handle handle, String sql) {
        super(handle, sql);
        this.requireSemicolon = handle.getConfig(SqlStatements.class).isScriptStatementsNeedSemicolon();
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        try (Batch b = this.getHandle().createBatch();){
            statements.forEach(b::add);
            int[] nArray = b.execute();
            return nArray;
        }
    }

    public void executeAsSeparateStatements() {
        for (String s : this.getStatements()) {
            this.getHandle().execute(s, new Object[0]);
        }
    }

    public List<String> getStatements() {
        TemplateEngine templateEngine = this.getConfig(SqlStatements.class).getTemplateEngine();
        return this.splitToStatements(templateEngine.render(this.getSql(), this.getContext()));
    }

    private List<String> splitToStatements(String script) {
        SqlScriptParser.ScriptTokenHandler scriptTokenHandler = new SqlScriptParser.ScriptTokenHandler(this.requireSemicolon);
        String lastStatement = new SqlScriptParser(scriptTokenHandler).parse($CharStreams.fromString(script));
        return scriptTokenHandler.addStatement(lastStatement);
    }
}

