/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.internal.UtilityClassException;
import bending.libraries.jdbi.v3.core.statement.SqlLogger;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.core.statement.internal.SqlLoggable;
import java.sql.SQLException;
import java.time.Instant;

class SqlLoggerUtil {
    private SqlLoggerUtil() {
        throw new UtilityClassException();
    }

    static <T> T wrap(SqlLoggable<T> r, StatementContext ctx, SqlLogger logger) throws SQLException {
        try {
            ctx.setExecutionMoment(Instant.now());
            logger.logBeforeExecution(ctx);
            T result = r.invoke();
            ctx.setCompletionMoment(Instant.now());
            logger.logAfterExecution(ctx);
            return result;
        }
        catch (SQLException e) {
            ctx.setExceptionMoment(Instant.now());
            logger.logException(ctx, e);
            throw e;
        }
    }
}

