/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.statement.NoTemplateEngine;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.core.statement.UnableToCreateStatementException;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface TemplateEngine {
    public static final TemplateEngine NOP = new NoTemplateEngine();

    public String render(String var1, StatementContext var2);

    default public Optional<Function<StatementContext, String>> parse(String template, ConfigRegistry config) {
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface Parsing
    extends TemplateEngine {
        @Override
        default public String render(String template, StatementContext ctx) {
            return this.parse(template, ctx.getConfig()).orElseThrow(() -> new UnableToCreateStatementException("Caching template engine did not prepare")).apply(ctx);
        }

        @Override
        public Optional<Function<StatementContext, String>> parse(String var1, ConfigRegistry var2);
    }
}

