/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement.internal;

import bending.libraries.jdbi.v3.core.statement.JdbiStatementEvent;
import bending.libraries.jdbi.v3.core.statement.internal.NoStatementEvent;
import bending.libraries.jdbi.v3.core.statement.internal.OptionalEvent;
import java.lang.reflect.Method;

public final class JfrSupport {
    private static final boolean JFR_AVAILABLE = ModuleLayer.boot().findModule("jdk.jfr").isPresent();
    private static final boolean FLIGHT_RECORDER_AVAILABLE;

    private JfrSupport() {
        throw new AssertionError((Object)"JfrSupport can not be instantiated");
    }

    public static boolean isJfrAvailable() {
        return JFR_AVAILABLE;
    }

    public static boolean isFlightRecorderAvailable() {
        return FLIGHT_RECORDER_AVAILABLE;
    }

    public static OptionalEvent newStatementEvent() {
        if (JfrSupport.isFlightRecorderAvailable()) {
            return Holder.newEvent();
        }
        return new NoStatementEvent();
    }

    static {
        boolean flightRecorderAvailable = false;
        if (JfrSupport.isJfrAvailable()) {
            try {
                Class<?> flightRecorder = Class.forName("jdk.jfr.FlightRecorder");
                Method isAvailable = flightRecorder.getMethod("isAvailable", new Class[0]);
                flightRecorderAvailable = (Boolean)isAvailable.invoke(null, new Object[0]);
                if (flightRecorderAvailable) {
                    Method register = flightRecorder.getMethod("register", Class.class);
                    register.invoke(null, JdbiStatementEvent.class);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        FLIGHT_RECORDER_AVAILABLE = flightRecorderAvailable;
    }

    private static final class Holder {
        private Holder() {
        }

        public static OptionalEvent newEvent() {
            return new JdbiStatementEvent();
        }
    }
}

