/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.transaction;

import bending.libraries.jdbi.v3.core.Handle;
import bending.libraries.jdbi.v3.core.HandleCallback;
import bending.libraries.jdbi.v3.core.internal.exceptions.Unchecked;
import bending.libraries.jdbi.v3.core.transaction.TransactionException;
import bending.libraries.jdbi.v3.core.transaction.TransactionHandler;
import bending.libraries.jdbi.v3.core.transaction.TransactionIsolationLevel;
import bending.libraries.jdbi.v3.core.transaction.UnableToRestoreAutoCommitStateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class LocalTransactionHandler
implements TransactionHandler {
    private final Map<Handle, BoundLocalTransactionHandler> bound = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public void begin(Handle handle) {
        this.nonspecial(handle).begin(handle);
    }

    @Override
    public void commit(Handle handle) {
        this.nonspecial(handle).commit(handle);
    }

    @Override
    public void rollback(Handle handle) {
        this.nonspecial(handle).rollback(handle);
    }

    @Override
    public boolean isInTransaction(Handle handle) {
        return this.nonspecial(handle).isInTransaction(handle);
    }

    @Override
    public void savepoint(Handle handle, String savepointName) {
        this.nonspecial(handle).savepoint(handle, savepointName);
    }

    @Override
    public void rollbackToSavepoint(Handle handle, String savepointName) {
        this.nonspecial(handle).rollbackToSavepoint(handle, savepointName);
    }

    @Override
    public void releaseSavepoint(Handle handle, String savepointName) {
        this.nonspecial(handle).releaseSavepoint(handle, savepointName);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        return this.nonspecial(handle).inTransaction(handle, callback);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        return this.nonspecial(handle).inTransaction(handle, level, callback);
    }

    TransactionHandler nonspecial(Handle handle) {
        return this.bound.computeIfAbsent(handle, Unchecked.function(BoundLocalTransactionHandler::new));
    }

    public static LocalTransactionHandler binding() {
        return new BindingLocalTransactionHandler();
    }

    public void reset(Handle handle) {
        this.bound.remove(handle);
    }

    static class BindingLocalTransactionHandler
    extends LocalTransactionHandler {
        BindingLocalTransactionHandler() {
        }

        @Override
        public TransactionHandler specialize(Handle handle) throws SQLException {
            return new BoundLocalTransactionHandler(handle);
        }
    }

    static class BoundLocalTransactionHandler
    implements TransactionHandler {
        private final Map<String, Savepoint> savepoints = new HashMap<String, Savepoint>();
        private boolean initialAutocommit;
        private State handlerState;

        BoundLocalTransactionHandler(Handle handle) throws SQLException {
            this.initialAutocommit = handle.getConnection().getAutoCommit();
            this.handlerState = this.getInitialHandlerState();
        }

        @Override
        public void begin(Handle handle) {
            try {
                if (this.handlerState == State.OUTSIDE_TRANSACTION) {
                    Connection conn = handle.getConnection();
                    this.initialAutocommit = conn.getAutoCommit();
                    this.savepoints.clear();
                    conn.setAutoCommit(false);
                    this.handlerState = State.AFTER_BEGIN;
                }
            }
            catch (SQLException e) {
                throw new TransactionException("Failed to start transaction", e);
            }
        }

        @Override
        public void commit(Handle handle) {
            try {
                if (this.handlerState != State.OUTSIDE_TRANSACTION) {
                    handle.getConnection().commit();
                }
                this.handlerState = this.getInitialHandlerState();
                this.restoreAutoCommitState(handle);
            }
            catch (SQLException e) {
                try {
                    this.rollback(handle);
                }
                catch (Exception rollbackException) {
                    e.addSuppressed(rollbackException);
                }
                throw new TransactionException("Failed to commit transaction", e);
            }
        }

        @Override
        public void rollback(Handle handle) {
            try {
                if (this.handlerState != State.OUTSIDE_TRANSACTION) {
                    handle.getConnection().rollback();
                }
            }
            catch (SQLException e) {
                throw new TransactionException("Failed to rollback transaction", e);
            }
            finally {
                this.handlerState = this.getInitialHandlerState();
                this.restoreAutoCommitState(handle);
            }
        }

        @Override
        public void savepoint(Handle handle, String name) {
            Connection conn = handle.getConnection();
            try {
                Savepoint savepoint = conn.setSavepoint(name);
                this.savepoints.put(name, savepoint);
            }
            catch (SQLException e) {
                throw new TransactionException(String.format("Unable to create savepoint '%s'", name), e);
            }
        }

        @Override
        public void releaseSavepoint(Handle handle, String name) {
            Connection conn = handle.getConnection();
            try {
                Savepoint savepoint = this.savepoints.remove(name);
                if (savepoint == null) {
                    throw new TransactionException(String.format("Attempt to release non-existent savepoint, '%s'", name));
                }
                conn.releaseSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new TransactionException(String.format("Unable to create savepoint %s", name), e);
            }
        }

        @Override
        public void rollbackToSavepoint(Handle handle, String name) {
            Connection conn = handle.getConnection();
            try {
                Savepoint savepoint = this.savepoints.remove(name);
                if (savepoint == null) {
                    throw new TransactionException(String.format("Attempt to rollback to non-existent savepoint, '%s'", name));
                }
                conn.rollback(savepoint);
            }
            catch (SQLException e) {
                throw new TransactionException(String.format("Unable to create savepoint %s", name), e);
            }
        }

        @Override
        public boolean isInTransaction(Handle handle) {
            try {
                return this.handlerState == State.IN_TRANSACTION || !handle.getConnection().getAutoCommit();
            }
            catch (SQLException e) {
                throw new TransactionException("Failed to test for transaction status", e);
            }
        }

        @Override
        public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
            if (this.isInTransaction(handle)) {
                throw new IllegalStateException("Already in transaction");
            }
            try {
                handle.begin();
                this.handlerState = State.IN_TRANSACTION;
                R returnValue = callback.withHandle(handle);
                if (this.handlerState == State.IN_TRANSACTION) {
                    handle.commit();
                }
                return returnValue;
            }
            catch (Throwable e) {
                if (this.handlerState == State.IN_TRANSACTION) {
                    try {
                        handle.rollback();
                    }
                    catch (Exception rollback) {
                        e.addSuppressed(rollback);
                    }
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
            TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
            try {
                handle.setTransactionIsolationLevel(level);
                R r = this.inTransaction(handle, callback);
                return r;
            }
            finally {
                handle.setTransactionIsolationLevel(initial);
            }
        }

        private void restoreAutoCommitState(Handle handle) {
            try {
                handle.getConnection().setAutoCommit(this.initialAutocommit);
            }
            catch (SQLException e) {
                throw new UnableToRestoreAutoCommitStateException(e);
            }
            finally {
                if (this.initialAutocommit) {
                    this.savepoints.clear();
                }
            }
        }

        private State getInitialHandlerState() {
            return this.initialAutocommit ? State.OUTSIDE_TRANSACTION : State.AFTER_BEGIN;
        }

        static enum State {
            OUTSIDE_TRANSACTION,
            AFTER_BEGIN,
            IN_TRANSACTION;

        }
    }
}

