/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.SequenceStep;

public final class SequenceBuilder {
    private final List<SequenceStep> steps = new ArrayList<SequenceStep>();

    SequenceBuilder() {
    }

    public SequenceBuilder add(AbilityDescription ability, Activation activation) {
        Objects.requireNonNull(ability);
        Objects.requireNonNull(activation);
        if (this.steps.size() > 16) {
            throw new IllegalStateException("Cannot add more than %d steps.".formatted(16));
        }
        if (!ability.canBind()) {
            throw new IllegalArgumentException("%s cannot be used as a sequence activation step.".formatted(ability.key().asString()));
        }
        if (activation == Activation.PASSIVE || activation == Activation.SEQUENCE) {
            throw new IllegalArgumentException("%s cannot be used for sequence activation.".formatted(activation.name()));
        }
        this.steps.add(SequenceStep.of(ability, activation));
        return this;
    }

    public SequenceBuilder add(AbilityDescription ability, Activation activation, Activation ... activations) {
        this.add(ability, activation);
        if (activations != null) {
            for (Activation temp : activations) {
                this.add(ability, temp);
            }
        }
        return this;
    }

    List<SequenceStep> validateAndBuild() {
        if (this.steps.size() < 2) {
            throw new IllegalStateException("Sequences require at least 2 activation steps.");
        }
        return List.copyOf(this.steps);
    }
}

