/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.user.User;
import me.moros.math.Vector3d;

class SelectedSourceImpl
implements SelectedSource {
    private StateChain chain;
    private final User user;
    private Vector3d origin;
    protected Block block;
    protected BlockType type;
    private final double distanceSq;
    private boolean started;
    private boolean forceRemove;

    protected SelectedSourceImpl(User user, Block block, double maxDistance) {
        this.user = user;
        this.distanceSq = 0.25 + maxDistance * maxDistance;
        this.updateBlock(block);
    }

    @Override
    public boolean reselect(Block block) {
        if (this.block.equals(block)) {
            return false;
        }
        Vector3d newOrigin = block.center();
        if (this.user.eyeLocation().distanceSq(newOrigin) > this.distanceSq) {
            return false;
        }
        this.onDestroy();
        this.updateBlock(block);
        return true;
    }

    private void updateBlock(Block block) {
        this.block = block;
        this.origin = this.block.center();
        this.type = this.block.type();
    }

    @Override
    public void start(StateChain chain) {
        if (this.started) {
            return;
        }
        this.chain = chain;
        this.started = true;
    }

    @Override
    public void complete() {
        if (!this.started) {
            return;
        }
        if (this.block.type() != this.type) {
            this.forceRemove = true;
        }
        this.onDestroy();
        this.chain.chainStore().clear();
        if (this.forceRemove) {
            return;
        }
        this.chain.chainStore().add(this.block);
        this.chain.nextState();
    }

    @Override
    public Updatable.UpdateResult update() {
        if (!this.started || this.forceRemove) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.user.eyeLocation().distanceSq(this.origin) > this.distanceSq) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.render();
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public Block block() {
        return this.block;
    }

    protected void render() {
        Particle.SMOKE.builder(this.origin.add(0.0, 0.5, 0.0)).spawn(this.user.world());
    }
}

