/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.StreamSupport;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.KeyUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public final class CollisionPair
implements Keyed {
    private final AbilityDescription first;
    private final AbilityDescription second;
    private final boolean removeFirst;
    private final boolean removeSecond;
    private final Key key;
    private final int hashcode;

    CollisionPair(AbilityDescription first, AbilityDescription second, boolean removeFirst, boolean removeSecond) {
        this.first = first;
        this.second = second;
        this.removeFirst = removeFirst;
        this.removeSecond = removeSecond;
        this.key = CollisionPair.createKey(first, second);
        this.hashcode = 31 * Math.min(first.hashCode(), second.hashCode()) + Math.max(first.hashCode(), second.hashCode());
    }

    public AbilityDescription first() {
        return this.first;
    }

    public AbilityDescription second() {
        return this.second;
    }

    public boolean removeFirst() {
        return this.removeFirst;
    }

    public boolean removeSecond() {
        return this.removeSecond;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CollisionPair other = (CollisionPair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second) || this.first.equals(other.second) && this.second.equals(other.first);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.first.key().asString() + " (Remove: " + this.removeFirst + ") - " + this.second.key().asString() + "(Remove: " + this.removeSecond + ")";
    }

    public static Key createKey(AbilityDescription first, AbilityDescription second) {
        String s;
        String f = KeyUtil.concat(first.key());
        String value = f.compareTo(s = KeyUtil.concat(second.key())) > 0 ? f + "-" + s : s + "-" + f;
        return KeyUtil.simple(value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Key key() {
        return this.key;
    }

    public static final class Builder {
        private final List<CollisionLayer> layers = new ArrayList<CollisionLayer>();
        private final Collection<CollisionPair> simpleCollisions = new ArrayList<CollisionPair>();

        private Builder() {
        }

        public Builder layer(Iterable<Key> abilities) {
            this.layers.add(new CollisionLayer(this.mapAbilities(abilities), true));
            return this;
        }

        public Builder add(Key first, Key second, boolean removeFirst, boolean removeSecond) {
            return this.add(List.of(first), List.of(second), removeFirst, removeSecond);
        }

        public Builder add(Key first, Iterable<Key> second, boolean removeFirst, boolean removeSecond) {
            return this.add(List.of(first), second, removeFirst, removeSecond);
        }

        public Builder add(Iterable<Key> first, Iterable<Key> second, boolean removeFirst, boolean removeSecond) {
            for (AbilityDescription desc1 : this.mapAbilities(first)) {
                for (AbilityDescription desc2 : this.mapAbilities(second)) {
                    this.simpleCollisions.add(new CollisionPair(desc1, desc2, removeFirst, removeSecond));
                }
            }
            return this;
        }

        public Collection<CollisionPair> build() {
            HashSet<CollisionPair> collisionSet = new HashSet<CollisionPair>(this.simpleCollisions);
            int size = this.layers.size();
            for (int i = 0; i < size; ++i) {
                CollisionLayer currentLayer = this.layers.get(i);
                if (currentLayer.interCollisions) {
                    collisionSet.addAll(Builder.registerSelfCancellingCollisions(currentLayer.layerAbilities));
                }
                for (int j = i + 1; j < size; ++j) {
                    CollisionLayer layerAbove = this.layers.get(j);
                    for (AbilityDescription first : currentLayer.layerAbilities) {
                        for (AbilityDescription second : layerAbove.layerAbilities) {
                            collisionSet.add(new CollisionPair(first, second, true, false));
                        }
                    }
                }
            }
            return collisionSet;
        }

        private List<AbilityDescription> mapAbilities(Iterable<Key> abilities) {
            return StreamSupport.stream(abilities.spliterator(), false).map(Registries.ABILITIES::getOrThrow).toList();
        }

        private static Collection<CollisionPair> registerSelfCancellingCollisions(List<AbilityDescription> layer) {
            ArrayList<CollisionPair> tempCollisions = new ArrayList<CollisionPair>();
            int size = layer.size();
            for (int i = 0; i < size; ++i) {
                for (int j = i; j < size; ++j) {
                    tempCollisions.add(new CollisionPair(layer.get(i), layer.get(j), true, true));
                }
            }
            return tempCollisions;
        }
    }

    private record CollisionLayer(List<AbilityDescription> layerAbilities, boolean interCollisions) {
    }
}

