/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision;

import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import net.kyori.adventure.util.TriState;

public final class CollisionUtil {
    private CollisionUtil() {
    }

    public static boolean handle(User user, Collider collider, CollisionCallback callback) {
        return CollisionUtil.handle(user, collider, callback, true, false, false);
    }

    public static boolean handle(User user, Collider collider, CollisionCallback callback, boolean livingOnly) {
        return CollisionUtil.handle(user, collider, callback, livingOnly, false, false);
    }

    public static boolean handle(User user, Collider collider, CollisionCallback callback, boolean livingOnly, boolean selfCollision) {
        return CollisionUtil.handle(user, collider, callback, livingOnly, selfCollision, false);
    }

    public static boolean handle(User user, Collider collider, CollisionCallback callback, boolean livingOnly, boolean selfCollision, boolean earlyEscape) {
        boolean hit = false;
        Predicate<Entity> filter = CollisionUtil.entityPredicate(user, livingOnly, selfCollision);
        for (Entity entity : user.world().nearbyEntities(collider.outer(), filter)) {
            if (!collider.intersects(entity.bounds()) || !user.canBuild(entity.block())) continue;
            boolean result = callback.onEntityHit(entity);
            if (earlyEscape && result) {
                return true;
            }
            hit |= result;
        }
        return hit;
    }

    private static Predicate<Entity> entityPredicate(Entity source, boolean livingOnly, boolean selfCollision) {
        Predicate<Entity> livingPredicate = livingOnly ? e -> e instanceof LivingEntity : e -> true;
        Predicate<Entity> selfPredicate = !selfCollision ? e -> !e.uuid().equals(source.uuid()) : e -> true;
        Predicate<Entity> valid = CollisionUtil::isValidEntity;
        return selfPredicate.and(livingPredicate).and(valid);
    }

    private static boolean isValidEntity(Entity entity) {
        EntityType type = entity.type();
        if (type == EntityType.PLAYER) {
            return entity.property(EntityProperties.GAMEMODE) != GameMode.SPECTATOR;
        }
        if (entity.type() == EntityType.FALLING_BLOCK) {
            return !TempEntity.MANAGER.isTemp(entity.id());
        }
        if (entity.type() == EntityType.ARMOR_STAND) {
            return entity.checkProperty(EntityProperties.INVISIBLE) != TriState.TRUE;
        }
        return true;
    }

    @FunctionalInterface
    public static interface CollisionCallback {
        public boolean onEntityHit(Entity var1);
    }
}

