/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import java.util.function.BiPredicate;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Disk;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.math.Vector3d;

final class ColliderUtil {
    private static final Resolver[][] RESOLVERS = new Resolver[5][];

    private ColliderUtil() {
    }

    private static <C0 extends Collider, C1 extends Collider> void addMapping(Collider.Type first, Collider.Type second, Resolver<C0, C1> resolver) {
        int firstId = first.ordinal();
        int secondId = second.ordinal();
        ColliderUtil.RESOLVERS[firstId][secondId] = resolver;
        if (firstId != secondId) {
            ColliderUtil.RESOLVERS[secondId][firstId] = resolver.inverse();
        }
    }

    static boolean intersects(Collider first, Collider second) {
        return RESOLVERS[first.type().ordinal()][second.type().ordinal()].test(first, second);
    }

    private static boolean aabbIntersectsSphere(AABB aabb, Sphere sphere) {
        Vector3d min = aabb.min();
        Vector3d max = aabb.max();
        double x = Math.clamp(sphere.position().x(), min.x(), max.x());
        double y = Math.clamp(sphere.position().y(), min.y(), max.y());
        double z = Math.clamp(sphere.position().z(), min.z(), max.z());
        return sphere.contains(Vector3d.of(x, y, z));
    }

    private static boolean sphereIntersectsRay(Sphere sphere, Ray ray) {
        Vector3d m = (Vector3d)ray.position().subtract(sphere.position());
        double b = ray.direction().dot(m);
        return m.lengthSq() - b * b / ray.direction().lengthSq() <= sphere.radius() * sphere.radius();
    }

    private static boolean aabbIntersectsRay(AABB aabb, Ray ray) {
        Vector3d t1;
        Vector3d t0 = (Vector3d)((Vector3d)aabb.min().subtract(ray.position())).multiply(ray.inv());
        return t0.min(t1 = (Vector3d)((Vector3d)aabb.max().subtract(ray.position())).multiply(ray.inv())).maxComponent() <= t0.max(t1).minComponent();
    }

    private static boolean obbIntersectsSphere(OBB obb, Sphere sphere) {
        Vector3d v = (Vector3d)sphere.position().subtract(obb.closestPosition(sphere.position()));
        return v.dot(v) <= sphere.radius() * sphere.radius();
    }

    private static boolean obbIntersectsAabb(OBB obb, AABB aabb) {
        return ColliderUtil.obbIntersection(obb, OBB.of(aabb));
    }

    private static boolean obbIntersectsRay(OBB obb, Ray ray) {
        Ray localRay = Ray.of(obb.localSpace(ray.position()), obb.localSpace(ray.direction()));
        AABB localAABB = AABB.of(obb.extents().negate(), obb.extents()).at(obb.position());
        return ColliderUtil.aabbIntersectsRay(localAABB, localRay);
    }

    private static boolean diskIntersectsSphere(Disk disk, Sphere sphere) {
        return ColliderUtil.sphereIntersection(disk.sphere(), sphere) && ColliderUtil.obbIntersectsSphere(disk.obb(), sphere);
    }

    private static boolean diskIntersectsAabb(Disk disk, AABB aabb) {
        return ColliderUtil.aabbIntersectsSphere(aabb, disk.sphere()) && ColliderUtil.obbIntersection(disk.obb(), OBB.of(aabb));
    }

    private static boolean diskIntersectsObb(Disk disk, OBB obb) {
        return ColliderUtil.obbIntersectsSphere(obb, disk.sphere()) && ColliderUtil.obbIntersection(disk.obb(), obb);
    }

    private static boolean diskIntersectsRay(Disk disk, Ray ray) {
        return ColliderUtil.sphereIntersectsRay(disk.sphere(), ray) && ColliderUtil.obbIntersectsRay(disk.obb(), ray);
    }

    private static boolean sphereIntersection(Sphere first, Sphere other) {
        double sum = first.radius() + other.radius();
        return other.position().distanceSq(first.position()) <= sum * sum;
    }

    private static boolean aabbIntersection(AABB first, AABB other) {
        return first.max().x() > other.min().x() && first.min().x() < other.max().x() && first.max().y() > other.min().y() && first.min().y() < other.max().y() && first.max().z() > other.min().z() && first.min().z() < other.max().z();
    }

    private static boolean obbIntersection(OBB first, OBB other) {
        int i;
        if (!ColliderUtil.aabbIntersection(first.outer(), other.outer())) {
            return false;
        }
        Vector3d pos = (Vector3d)other.position().subtract(first.position());
        for (i = 0; i < 3; ++i) {
            if (!ColliderUtil.getSeparatingPlane(first, pos, first.axis(i), other) && !ColliderUtil.getSeparatingPlane(first, pos, other.axis(i), other)) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!ColliderUtil.getSeparatingPlane(first, pos, first.axis(i).cross(other.axis(j)), other)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean getSeparatingPlane(OBB first, Vector3d pos, Vector3d plane, OBB other) {
        double z2;
        double y2;
        double x2;
        double z1;
        double y1;
        double x1;
        double dot = Math.abs(pos.dot(plane));
        return dot > (x1 = Math.abs(((Vector3d)first.axis(0).multiply(first.extents().x())).dot(plane))) + (y1 = Math.abs(((Vector3d)first.axis(1).multiply(first.extents().y())).dot(plane))) + (z1 = Math.abs(((Vector3d)first.axis(2).multiply(first.extents().z())).dot(plane))) + (x2 = Math.abs(((Vector3d)other.axis(0).multiply(other.extents().x())).dot(plane))) + (y2 = Math.abs(((Vector3d)other.axis(1).multiply(other.extents().y())).dot(plane))) + (z2 = Math.abs(((Vector3d)other.axis(2).multiply(other.extents().z())).dot(plane)));
    }

    private static boolean rayIntersection(Ray first, Ray other) {
        Vector3d cross = first.direction().cross(other.direction());
        if (cross.lengthSq() < 0.001) {
            return first.contains(other.position()) || other.contains(first.position());
        }
        double planarFactor = ((Vector3d)other.position().subtract(first.position())).dot(cross);
        return Math.abs(planarFactor) < 0.001;
    }

    private static boolean diskIntersection(Disk first, Disk other) {
        return ColliderUtil.sphereIntersection(first.sphere(), other.sphere()) && ColliderUtil.obbIntersection(first.obb(), other.obb());
    }

    static {
        for (int i = 0; i < RESOLVERS.length; ++i) {
            ColliderUtil.RESOLVERS[i] = new Resolver[5];
        }
        ColliderUtil.addMapping(Collider.Type.SPHERE, Collider.Type.SPHERE, ColliderUtil::sphereIntersection);
        ColliderUtil.addMapping(Collider.Type.AABB, Collider.Type.AABB, ColliderUtil::aabbIntersection);
        ColliderUtil.addMapping(Collider.Type.OBB, Collider.Type.OBB, ColliderUtil::obbIntersection);
        ColliderUtil.addMapping(Collider.Type.RAY, Collider.Type.RAY, ColliderUtil::rayIntersection);
        ColliderUtil.addMapping(Collider.Type.DISK, Collider.Type.DISK, ColliderUtil::diskIntersection);
        ColliderUtil.addMapping(Collider.Type.SPHERE, Collider.Type.RAY, ColliderUtil::sphereIntersectsRay);
        ColliderUtil.addMapping(Collider.Type.AABB, Collider.Type.SPHERE, ColliderUtil::aabbIntersectsSphere);
        ColliderUtil.addMapping(Collider.Type.AABB, Collider.Type.RAY, ColliderUtil::aabbIntersectsRay);
        ColliderUtil.addMapping(Collider.Type.OBB, Collider.Type.SPHERE, ColliderUtil::obbIntersectsSphere);
        ColliderUtil.addMapping(Collider.Type.OBB, Collider.Type.AABB, ColliderUtil::obbIntersectsAabb);
        ColliderUtil.addMapping(Collider.Type.OBB, Collider.Type.RAY, ColliderUtil::obbIntersectsRay);
        ColliderUtil.addMapping(Collider.Type.DISK, Collider.Type.SPHERE, ColliderUtil::diskIntersectsSphere);
        ColliderUtil.addMapping(Collider.Type.DISK, Collider.Type.AABB, ColliderUtil::diskIntersectsAabb);
        ColliderUtil.addMapping(Collider.Type.DISK, Collider.Type.OBB, ColliderUtil::diskIntersectsObb);
        ColliderUtil.addMapping(Collider.Type.DISK, Collider.Type.RAY, ColliderUtil::diskIntersectsRay);
    }

    @FunctionalInterface
    private static interface Resolver<C0 extends Collider, C1 extends Collider>
    extends BiPredicate<C0, C1> {
        default public Resolver<C1, C0> inverse() {
            return (first, second) -> this.test(second, first);
        }
    }
}

