/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.RayImpl;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public sealed interface Ray
extends Collider
permits RayImpl {
    public static final Ray ZERO = Ray.of(Vector3d.ZERO, Vector3d.ZERO);

    public Vector3d direction();

    public Vector3d inv();

    @Override
    default public Collider.Type type() {
        return Collider.Type.RAY;
    }

    @Override
    default public AABB outer() {
        return AABB.fromRay(this, 0.0);
    }

    @Override
    default public Ray at(Position point) {
        return Ray.of(point.toVector3d(), this.direction());
    }

    @Override
    default public Vector3d halfExtents() {
        return (Vector3d)this.direction().multiply(0.5);
    }

    @Override
    default public boolean contains(Vector3d point) {
        double lengthSq = this.direction().lengthSq();
        if (lengthSq == 0.0) {
            return this.position().distanceSq(point) < 0.001;
        }
        double t = Math.clamp(((Vector3d)point.subtract(this.position())).dot(this.direction()) / lengthSq, 0.0, 1.0);
        return ((Vector3d)this.position().add((Position)this.direction().multiply(t))).distanceSq(point) < 0.001;
    }

    public static Ray of(Vector3d origin, Vector3d direction) {
        return new RayImpl(origin, direction);
    }
}

