/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.raytrace;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.moros.bending.api.collision.raytrace.BlockRayTrace;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.ContextImpl;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.platform.world.World;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ContextBuilder {
    public static final double MIN_RANGE = 1.0;
    public static final double MAX_RANGE = 100.0;
    private Vector3d origin;
    private Vector3d direction;
    private double range;
    private double raySize = 0.0;
    private boolean ignoreLiquids = true;
    private boolean ignorePassable = true;
    private Set<Position> ignore = Set.of();
    private Predicate<Entity> entityPredicate = x -> true;

    ContextBuilder(Vector3d origin, Vector3d direction) {
        this.origin = origin;
        this.direction = direction.normalize();
        this.range(direction.length());
    }

    public ContextBuilder origin(Vector3d origin) {
        this.origin = Objects.requireNonNull(origin);
        return this;
    }

    public ContextBuilder direction(Vector3d direction) {
        this.direction = direction.normalize();
        return this;
    }

    public ContextBuilder range(double range) {
        this.range = Math.clamp(range, 1.0, 100.0);
        return this;
    }

    public ContextBuilder raySize(double raySize) {
        this.raySize = Math.max(0.0, raySize);
        return this;
    }

    public ContextBuilder ignoreLiquids(boolean ignoreLiquids) {
        this.ignoreLiquids = ignoreLiquids;
        return this;
    }

    public ContextBuilder ignorePassable(boolean ignorePassable) {
        this.ignorePassable = ignorePassable;
        return this;
    }

    public ContextBuilder ignore(@Nullable Position ignore) {
        this.ignore = ignore == null ? Set.of() : Set.of(ignore);
        return this;
    }

    public ContextBuilder ignore(Set<Position> ignore) {
        this.ignore = Set.copyOf(ignore);
        return this;
    }

    public ContextBuilder filter(Predicate<Entity> entityPredicate) {
        this.entityPredicate = Objects.requireNonNull(entityPredicate);
        return this;
    }

    public ContextBuilder filterForUser(Entity source) {
        Objects.requireNonNull(source);
        return this.filter(e -> ContextBuilder.userPredicate(e, source));
    }

    public BlockRayTrace blocks(World world) {
        return world.rayTraceBlocks(this.build());
    }

    public CompositeRayTrace cast(World world) {
        return world.rayTrace(this.build());
    }

    public Context build() {
        Vector3d endPoint = (Vector3d)this.origin.add((Position)this.direction.multiply(this.range));
        return new ContextImpl(this.origin, endPoint, this.range, this.raySize, this.ignoreLiquids, this.ignorePassable, ContextBuilder.deepCopy(this.ignore), this.entityPredicate);
    }

    private static Set<Vector3i> deepCopy(Collection<Position> col) {
        return col.stream().map(p -> Vector3i.of(p.blockX(), p.blockY(), p.blockZ())).collect(Collectors.toUnmodifiableSet());
    }

    private static boolean userPredicate(Entity check, Entity entity) {
        if (check.property(EntityProperties.GAMEMODE) == GameMode.SPECTATOR) {
            return false;
        }
        return check instanceof LivingEntity && !check.uuid().equals(entity.uuid());
    }
}

