/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.config;

import java.util.concurrent.ThreadLocalRandom;

public interface BendingProperties {
    private ThreadLocalRandom rand() {
        return ThreadLocalRandom.current();
    }

    public static BendingProperties instance() {
        return Holder.INSTANCE == null ? Holder.DEFAULTS : Holder.INSTANCE;
    }

    default public long earthRevertTime() {
        return 300000L;
    }

    default public long earthRevertTime(long delay) {
        return this.earthRevertTime() + this.rand().nextLong(delay);
    }

    default public long fireRevertTime() {
        return 10000L;
    }

    default public long fireRevertTime(long delay) {
        return this.fireRevertTime() + this.rand().nextLong(delay);
    }

    default public long explosionRevertTime() {
        return 20000L;
    }

    default public long explosionRevertTime(long delay) {
        return this.explosionRevertTime() + this.rand().nextLong(delay);
    }

    default public long iceRevertTime() {
        return 10000L;
    }

    default public long iceRevertTime(long delay) {
        return this.iceRevertTime() + this.rand().nextLong(delay);
    }

    default public double explosionKnockback() {
        return 0.8;
    }

    default public double explosionKnockback(double value) {
        return this.explosionKnockback() * value;
    }

    default public double metalModifier() {
        return 1.25;
    }

    default public double metalModifier(double value) {
        return this.metalModifier() * value;
    }

    default public double magmaModifier() {
        return 1.4;
    }

    default public double magmaModifier(double value) {
        return this.magmaModifier() * value;
    }

    default public double moonModifier() {
        return 1.25;
    }

    default public double moonModifier(double value) {
        return this.moonModifier() * value;
    }

    default public double sunModifier() {
        return 1.25;
    }

    default public double sunModifier(double value) {
        return this.sunModifier() * value;
    }

    default public boolean canGenerateLight() {
        return true;
    }

    default public boolean lazyLoad() {
        return false;
    }

    default public int maxPresets() {
        return 0;
    }

    public static final class Holder {
        public static final BendingProperties DEFAULTS = new BendingProperties(){};
        private static BendingProperties INSTANCE;

        private Holder() {
        }
    }
}

