/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.config.attribute;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeHolder;
import me.moros.bending.api.config.attribute.AttributeModifier;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.api.config.attribute.ModifyPolicy;
import net.kyori.adventure.key.Key;

record AttributeMap(Map<Key, AttributeModifier> modifierMap) implements AttributeHolder
{
    AttributeMap() {
        this(new ConcurrentHashMap<Key, AttributeModifier>());
    }

    @Override
    public boolean add(ModifyPolicy policy, Attribute attribute, Modifier modifier) {
        Key key = AttributeMap.extractKey(policy, attribute);
        this.modifierMap.merge(key, modifier.asAttributeModifier(policy, attribute), this::mergeEntries);
        return true;
    }

    private AttributeModifier mergeEntries(AttributeModifier first, AttributeModifier second) {
        return first.modifier().merge(second.modifier()).asAttributeModifier(first.policy(), first.attribute());
    }

    @Override
    public boolean remove(Predicate<AttributeModifier> predicate) {
        return this.modifierMap.entrySet().removeIf(e -> predicate.test((AttributeModifier)e.getValue()));
    }

    @Override
    public void clear() {
        this.modifierMap.clear();
    }

    @Override
    public Stream<AttributeModifier> stream() {
        return this.modifierMap.values().stream();
    }

    private static Key extractKey(ModifyPolicy policy, Attribute attribute) {
        String combinedValue = policy.key().value() + "/" + attribute.value().toLowerCase(Locale.ROOT);
        return Key.key((String)policy.key().namespace(), (String)combinedValue);
    }
}

