/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.config.attribute;

import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeModifier;
import me.moros.bending.api.config.attribute.ModifierImpl;
import me.moros.bending.api.config.attribute.ModifierOperation;
import me.moros.bending.api.config.attribute.ModifyPolicy;

public sealed interface Modifier
extends DoubleUnaryOperator
permits ModifierImpl {
    public Modifier merge(Modifier var1);

    public AttributeModifier asAttributeModifier(ModifyPolicy var1, Attribute var2);

    public static Modifier of(ModifierOperation type, double value) {
        Objects.requireNonNull(type);
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Invalid value " + value);
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ModifierOperation.ADDITIVE -> new ModifierImpl(value, 0.0, 1.0);
            case ModifierOperation.SUMMED_MULTIPLICATIVE -> new ModifierImpl(0.0, value, 1.0);
            case ModifierOperation.MULTIPLICATIVE -> new ModifierImpl(0.0, 0.0, value);
        };
    }
}

