/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.EntityTypeTag;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.functional.Suppliers;
import net.kyori.adventure.key.Key;

record TagImpl(Key key, Supplier<Container<EntityType>> supplier) implements EntityTypeTag
{
    private static final Container<EntityType> EMPTY = Container.create(KeyUtil.simple("empty"), Set.of());

    static EntityTypeTag get(String key) {
        return TagImpl.reference(KeyUtil.vanilla(key));
    }

    static EntityTypeTag reference(Key key) {
        return new TagImpl(key, Suppliers.lazy(() -> EntityType.registry().getTag(key)));
    }

    static EntityTypeTag fromContainer(Container<EntityType> container) {
        return new TagImpl(container.key(), Suppliers.cached(container));
    }

    Container<EntityType> container() {
        Container<EntityType> container = this.supplier().get();
        return container == null ? EMPTY : container;
    }

    @Override
    public boolean containsValue(EntityType type) {
        return this.container().containsValue(type);
    }

    @Override
    public int size() {
        return this.container().size();
    }

    @Override
    public Stream<EntityType> stream() {
        return this.container().stream();
    }

    @Override
    public Iterator<EntityType> iterator() {
        return this.container().iterator();
    }
}

