/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.particle;

import java.util.Objects;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.particle.ParticleContextImpl;
import me.moros.bending.api.platform.particle.ParticleDustData;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.RGBLike;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ParticleBuilder<T> {
    private static final RGBLike AIR = ParticleBuilder.fromHex("#EEEEEE");
    private final Particle particle;
    private final T data;
    private final Position position;
    private Position offset = Vector3d.ZERO;
    private int count = 1;
    private double extra = 0.0;

    private ParticleBuilder(Particle particle, @Nullable T data, Position position) {
        this.particle = particle;
        this.position = Objects.requireNonNull(position);
        this.data = data;
    }

    public ParticleBuilder<T> count(int count) {
        this.count = Math.max(0, count);
        return this;
    }

    public ParticleBuilder<T> offset(Position offset) {
        this.offset = Objects.requireNonNull(offset);
        return this;
    }

    public ParticleBuilder<T> offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    public ParticleBuilder<T> offset(double offsetX, double offsetY, double offsetZ) {
        return this.offset(Vector3d.of(offsetX, offsetY, offsetZ));
    }

    public ParticleBuilder<T> extra(double extra) {
        this.extra = extra;
        return this;
    }

    public ParticleContext<T> build() {
        return new ParticleContextImpl<T>(this.particle, this.position, this.offset, this.count, this.extra, this.data);
    }

    public void spawn(World world) {
        world.spawnParticle(this.build());
    }

    public static ParticleBuilder<ParticleDustData> air(Position center) {
        return ParticleBuilder.rgb(center, AIR, 1.8f);
    }

    public static ParticleBuilder<Void> bubble(Position center) {
        return Particle.BUBBLE.builder(center.center()).count(3).offset(0.25);
    }

    public static ParticleBuilder<Void> fire(User user, Position center) {
        Particle effect = user.hasPermission(FeaturePermissions.BLUE_FIRE) ? Particle.SOUL_FIRE_FLAME : Particle.FLAME;
        return effect.builder(center);
    }

    public static ParticleBuilder<ParticleDustData> rgb(Position center, String hexVal) {
        return ParticleBuilder.rgb(center, hexVal, 1.0f);
    }

    public static ParticleBuilder<ParticleDustData> rgb(Position center, RGBLike color) {
        return ParticleBuilder.rgb(center, color, 1.0f);
    }

    public static ParticleBuilder<ParticleDustData> rgb(Position center, String hexVal, float size) {
        return ParticleBuilder.rgb(center, ParticleBuilder.fromHex(hexVal), size);
    }

    public static ParticleBuilder<ParticleDustData> rgb(Position center, RGBLike color, float size) {
        return ParticleBuilder.of(Particle.DUST, ParticleDustData.simple(color, size), center);
    }

    public static ParticleBuilder<ParticleDustData.Transitive> rgb(Position center, String fromHexVal, String toHexVal) {
        return ParticleBuilder.rgb(center, fromHexVal, toHexVal, 1.0f);
    }

    public static ParticleBuilder<ParticleDustData.Transitive> rgb(Position center, RGBLike from, RGBLike to) {
        return ParticleBuilder.rgb(center, from, to, 1.0f);
    }

    public static ParticleBuilder<ParticleDustData.Transitive> rgb(Position center, String fromHexVal, String toHexVal, float size) {
        return ParticleBuilder.rgb(center, ParticleBuilder.fromHex(fromHexVal), ParticleBuilder.fromHex(toHexVal), size);
    }

    public static ParticleBuilder<ParticleDustData.Transitive> rgb(Position center, RGBLike from, RGBLike to, float size) {
        return ParticleBuilder.of(Particle.DUST_COLOR_TRANSITION, ParticleDustData.transitive(from, to, size), center);
    }

    static ParticleBuilder<Void> of(Particle effect, Position center) {
        return new ParticleBuilder<Object>(effect, null, center);
    }

    static <T> ParticleBuilder<T> of(Particle effect, T data, Position center) {
        return new ParticleBuilder<T>(effect, data, center);
    }

    private static RGBLike fromHex(String hexValue) {
        TextColor color = TextColor.fromHexString((String)hexValue);
        return color == null ? NamedTextColor.BLACK : color;
    }
}

