/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.world;

import java.util.List;
import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.math.Vector3d;

public interface EntityAccessor {
    default public List<Entity> nearbyEntities(Vector3d pos, double radius) {
        return this.nearbyEntities(pos, radius, block -> true, 0);
    }

    default public List<Entity> nearbyEntities(Vector3d pos, double radius, Predicate<Entity> predicate) {
        return this.nearbyEntities(pos, radius, predicate, 0);
    }

    default public List<Entity> nearbyEntities(Vector3d pos, double radius, Predicate<Entity> predicate, int limit) {
        AABB aabb = AABB.of((Vector3d)pos.subtract(radius, radius, radius), pos.add(radius, radius, radius));
        Predicate<Entity> distPredicate = e -> pos.distanceSq(e.location()) < radius * radius;
        return this.nearbyEntities(aabb, distPredicate.and(predicate), limit);
    }

    default public List<Entity> nearbyEntities(AABB box) {
        return this.nearbyEntities(box, block -> true, 0);
    }

    default public List<Entity> nearbyEntities(AABB box, Predicate<Entity> predicate) {
        return this.nearbyEntities(box, predicate, 0);
    }

    public List<Entity> nearbyEntities(AABB var1, Predicate<Entity> var2, int var3);
}

