/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.world;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public final class WorldUtil {
    public static final Set<Direction> FACES = Set.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN);
    public static final Set<Direction> SIDES = Set.of(Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH);

    private WorldUtil() {
    }

    public static void tryLightBlock(Block block) {
        if (MaterialUtil.isCampfire(block) || BlockTag.CANDLES.isTagged(block)) {
            block.setState((BlockState)block.state().withProperty((Property)BlockStateProperties.LIT, Boolean.valueOf(true)));
        }
    }

    public static void playLavaExtinguishEffect(Block block) {
        SoundEffect.LAVA_EXTINGUISH.play(block);
        Vector3d center = block.center().add(0.0, 0.2, 0.0);
        Particle.CLOUD.builder(center).count(8).offset(0.3).spawn(block.world());
    }

    public static boolean tryCoolLava(User user, Block block) {
        if (MaterialUtil.isLava(block) && user.canBuild(block)) {
            block.setType(MaterialUtil.isSourceBlock(block) ? BlockType.OBSIDIAN : BlockType.COBBLESTONE);
            if (ThreadLocalRandom.current().nextBoolean()) {
                WorldUtil.playLavaExtinguishEffect(block);
            }
            return true;
        }
        return false;
    }

    public static boolean tryExtinguishFire(User user, Block block) {
        if (!user.canBuild(block)) {
            return false;
        }
        if (MaterialUtil.isFire(block)) {
            block.setType(BlockType.AIR);
            if (ThreadLocalRandom.current().nextInt(4) == 0) {
                SoundEffect.FIRE_EXTINGUISH.play(block);
            }
            return true;
        }
        if (MaterialUtil.isCampfire(block) || BlockTag.CANDLES.isTagged(block)) {
            return block.setState((BlockState)block.state().withProperty((Property)BlockStateProperties.LIT, Boolean.valueOf(false)));
        }
        return false;
    }

    public static boolean tryMelt(User user, Block block) {
        if (!user.canBuild(block)) {
            return false;
        }
        if (WaterMaterials.isSnowBendable(block)) {
            int level;
            BlockState snow;
            if (block.type() == BlockType.SNOW_BLOCK) {
                snow = BlockType.SNOW.defaultState();
                level = BlockStateProperties.LAYERS.max();
            } else {
                snow = block.state();
                level = Objects.requireNonNull((Integer)snow.property(BlockStateProperties.LAYERS));
            }
            if (level == BlockStateProperties.LAYERS.min()) {
                block.setType(BlockType.AIR);
            } else {
                block.setState((BlockState)snow.withProperty((Property)BlockStateProperties.LAYERS, Integer.valueOf(level - 1)));
            }
            return true;
        }
        if (WaterMaterials.isIceBendable(block)) {
            TempBlock.MANAGER.get(block).ifPresentOrElse(TempBlock::revert, () -> TempBlock.air().build(block));
            return true;
        }
        return false;
    }

    public static boolean isInfiniteWater(Block block) {
        int sources = 0;
        for (Direction face : SIDES) {
            Block adjacent = block.offset(face);
            if (!MaterialUtil.isWater(adjacent) || !MaterialUtil.isSourceBlock(adjacent) || TempBlock.MANAGER.isTemp(adjacent)) continue;
            ++sources;
        }
        return sources >= 2;
    }

    public static Collection<Block> createBlockRing(Block center, double radius) {
        Vector3d centerVector = center.center();
        int steps = FastMath.ceil(10.0 * radius);
        return VectorUtil.circle((Vector3d)Vector3d.PLUS_I.multiply(radius), Vector3d.PLUS_J, steps).stream().map(v -> center.world().blockAt((Position)centerVector.add((Position)v))).distinct().toList();
    }

    public static boolean tryBreakPlant(Block block) {
        if (MaterialUtil.BREAKABLE_PLANTS.isTagged(block)) {
            if (TempBlock.MANAGER.isTemp(block)) {
                return false;
            }
            block.world().breakNaturally(block);
            return true;
        }
        return false;
    }
}

