/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.protection;

import bending.libraries.caffeine.cache.Caffeine;
import bending.libraries.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;

public enum ProtectionCache {
    INSTANCE;

    private final Map<UUID, LoadingCache<Block, Boolean>> cache = new ConcurrentHashMap<UUID, LoadingCache<Block, Boolean>>();

    public void invalidate(UUID uuid) {
        this.cache.remove(uuid);
    }

    public boolean canBuild(User user, Block block) {
        return (Boolean)this.cache.computeIfAbsent(user.uuid(), u -> this.buildCache(user)).get(block);
    }

    private boolean canBuildPostCache(User user, Block block) {
        return Registries.PROTECTIONS.stream().allMatch(m -> m.canBuild(user, block));
    }

    private LoadingCache<Block, Boolean> buildCache(User user) {
        return Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(b -> this.canBuildPostCache(user, (Block)b));
    }
}

