/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.UUID;
import java.util.stream.Stream;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.registry.SimpleRegistry;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.TextUtil;

public final class UserRegistry
extends SimpleRegistry.SimpleMutableRegistry<UUID, User> {
    UserRegistry() {
        super(KeyUtil.data("user", User.class), Entity::uuid, TextUtil::parseUUID);
    }

    @Override
    public boolean register(User user) {
        if (super.register(user)) {
            user.game().eventBus().postUserRegisterEvent(user);
            return true;
        }
        return false;
    }

    @Override
    public boolean clear() {
        return false;
    }

    public Stream<User> players() {
        return this.stream().filter(Player.class::isInstance);
    }

    public int playersCount() {
        return (int)this.players().count();
    }

    public int nonPlayerCount() {
        return this.size() - this.playersCount();
    }
}

