/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.EquipmentSlot;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.metadata.Metadata;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TempArmor
extends Temporary {
    public static final TemporalManager<UUID, TempArmor> MANAGER = new TemporalManager(2400);
    private final LivingEntity entity;
    private boolean reverted = false;

    private TempArmor(LivingEntity entity, int ticks) {
        this.entity = entity;
        MANAGER.addEntry(entity.uuid(), this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.reverted = true;
        Inventory equipment = Objects.requireNonNull(this.entity.inventory());
        for (EquipmentSlot slot : EquipmentSlot.ARMOR) {
            if (!equipment.item(slot).has(Metadata.ARMOR_KEY)) continue;
            equipment.item(slot, ItemSnapshot.AIR.get());
        }
        MANAGER.removeEntry(this.entity.uuid());
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder leather() {
        return TempArmor.builder().head(Item.LEATHER_HELMET).chest(Item.LEATHER_CHESTPLATE).legs(Item.LEATHER_LEGGINGS).feet(Item.LEATHER_BOOTS);
    }

    public static Builder iron() {
        return TempArmor.builder().head(Item.IRON_HELMET).chest(Item.IRON_CHESTPLATE).legs(Item.IRON_LEGGINGS).feet(Item.IRON_BOOTS);
    }

    public static Builder gold() {
        return TempArmor.builder().head(Item.GOLDEN_HELMET).chest(Item.GOLDEN_CHESTPLATE).legs(Item.GOLDEN_LEGGINGS).feet(Item.GOLDEN_BOOTS);
    }

    public static final class Builder {
        private final EnumMap<EquipmentSlot, Item> armor = new EnumMap(EquipmentSlot.class);
        private long duration = 30000L;

        private Builder() {
        }

        private Builder safePutItem(EquipmentSlot slot, @Nullable Item material) {
            if (material == null) {
                this.armor.remove((Object)slot);
            } else {
                this.armor.put(slot, material);
            }
            return this;
        }

        public Builder head(@Nullable Item material) {
            return this.safePutItem(EquipmentSlot.HEAD, material);
        }

        public Builder chest(@Nullable Item material) {
            return this.safePutItem(EquipmentSlot.CHEST, material);
        }

        public Builder legs(@Nullable Item material) {
            return this.safePutItem(EquipmentSlot.LEGS, material);
        }

        public Builder feet(@Nullable Item material) {
            return this.safePutItem(EquipmentSlot.FEET, material);
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Optional<TempArmor> build(User user) {
            Objects.requireNonNull(user);
            Inventory inv = user.inventory();
            if (MANAGER.isTemp(user.uuid()) || inv == null) {
                return Optional.empty();
            }
            List<Map.Entry> armorItems = this.armor.entrySet().stream().filter(e -> inv.item((EquipmentSlot)((Object)((Object)e.getKey()))).type() == Item.AIR).map(e -> Map.entry((EquipmentSlot)((Object)((Object)e.getKey())), this.createArmorItem((Item)e.getValue()))).toList();
            if (armorItems.isEmpty()) {
                return Optional.empty();
            }
            for (Map.Entry entry : armorItems) {
                inv.item((EquipmentSlot)((Object)entry.getKey()), (ItemSnapshot)entry.getValue());
            }
            return Optional.of(new TempArmor(user, MANAGER.fromMillis(this.duration)));
        }

        private ItemSnapshot createArmorItem(Item type) {
            return Platform.instance().factory().itemBuilder(type).name((Component)Component.text((String)"Bending Armor")).lore(List.of(Component.text((String)"Temporary"))).unbreakable(true).meta(Metadata.ARMOR_KEY, true).build();
        }
    }
}

