/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.DamageSource;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.FastMath;
import me.moros.tasker.TimerWheel;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TempBlock
extends Temporary {
    private static final TimerWheel wheel = TimerWheel.hierarchical();
    public static final TemporalManager<Block, TempBlock> MANAGER = new TemporalManager(wheel);
    private static final Set<Block> GRAVITY_CACHE = ConcurrentHashMap.newKeySet();
    private final Deque<TempBlockState> snapshots = new ArrayDeque<TempBlockState>();
    private final Block block;
    private Snapshot index;
    private int repeat;
    private boolean reverted = false;

    private TempBlock(Block block, BlockState state, int ticks, Builder builder) {
        this.block = block;
        this.addState(state, ticks, builder);
        MANAGER.addEntry(block, this, ticks);
    }

    private void addState(BlockState state, int ticks, Builder builder) {
        this.cleanStates();
        if (this.index == null || !this.index.weak) {
            TempBlockState tbs = new TempBlockState(this.block, ticks, builder);
            this.snapshots.offerLast(tbs);
            this.index = tbs;
        } else {
            this.index.weak = builder.weak;
        }
        this.block.setState(state);
        TempBlock.refreshGravityCache(this.block);
    }

    private void cleanStates() {
        if (this.snapshots.size() > 1) {
            Iterator<TempBlockState> it = this.snapshots.iterator();
            it.next();
            int tick = wheel.currentTick();
            while (it.hasNext()) {
                if (tick <= it.next().expirationTicks) continue;
                it.remove();
            }
        }
    }

    private TempBlockState cleanStatesReverse() {
        TempBlockState toRevert = Objects.requireNonNull(this.snapshots.pollLast());
        Iterator<TempBlockState> it = this.snapshots.descendingIterator();
        int tick = wheel.currentTick();
        while (it.hasNext()) {
            TempBlockState next = it.next();
            if (tick < next.expirationTicks) break;
            it.remove();
            toRevert = next;
        }
        return toRevert;
    }

    @Override
    public boolean revert() {
        this.repeat = 0;
        if (MANAGER.clearing()) {
            this.revertFully();
            return true;
        }
        if (this.reverted || this.snapshots.isEmpty()) {
            return false;
        }
        TempBlockState toRevert = this.cleanStatesReverse();
        if (this.snapshots.isEmpty()) {
            this.snapshots.offer(toRevert);
            this.revertFully();
            return true;
        }
        int t = toRevert.expirationTicks;
        this.revertToSnapshot(toRevert);
        TempBlockState nextState = this.snapshots.peekLast();
        if (nextState != null) {
            this.repeat = Math.max(0, nextState.expirationTicks - t);
        }
        return false;
    }

    @Override
    public int repeat() {
        return this.repeat;
    }

    public Block block() {
        return this.block;
    }

    public @Nullable DamageSource damageSource() {
        return this.index.source;
    }

    public void removeWithoutReverting() {
        this.cleanup();
    }

    private void revertFully() {
        if (this.reverted || this.snapshots.isEmpty()) {
            this.reverted = true;
            return;
        }
        this.revertToSnapshot(this.snapshots.pollFirst());
        this.cleanup();
        this.reverted = true;
    }

    private void revertToSnapshot(Snapshot snapshot) {
        this.index = snapshot;
        snapshot.revert();
        TempBlock.refreshGravityCache(this.block);
    }

    public static void revertToSnapshot(Block block, @Nullable Snapshot snapshot) {
        Consumer<TempBlock> func = snapshot == null ? TempBlock::revert : tb -> tb.revertToSnapshot(snapshot);
        MANAGER.get(block).ifPresentOrElse(func, () -> {
            if (snapshot != null) {
                snapshot.revert();
            }
        });
    }

    private void cleanup() {
        this.snapshots.clear();
        GRAVITY_CACHE.remove(this.block);
        MANAGER.removeEntry(this.block);
    }

    public Snapshot snapshot() {
        return new Snapshot(this.block, this.index.bendable, this.index.weak, this.index.source);
    }

    public static boolean isBendable(Block block) {
        return MANAGER.get(block).map(tb -> tb.index.bendable).orElse(true);
    }

    public static boolean shouldIgnorePhysics(Block block) {
        return GRAVITY_CACHE.contains(block);
    }

    public static BlockType getLastValidType(Block block) {
        TempBlock tb = MANAGER.get(block).orElse(null);
        if (tb != null && tb.index.weak) {
            return tb.index.state.type();
        }
        return block.type();
    }

    private static void refreshGravityCache(Block block) {
        if (block.type().hasGravity()) {
            GRAVITY_CACHE.add(block);
        } else {
            GRAVITY_CACHE.remove(block);
        }
    }

    public static Builder builder(BlockType type) {
        return TempBlock.builder(type.defaultState());
    }

    public static Builder builder(BlockState state) {
        return new Builder(Objects.requireNonNull(state));
    }

    public static Builder fire() {
        return TempBlock.builder(BlockType.FIRE).bendable(true);
    }

    public static Builder water() {
        return TempBlock.builder(BlockType.WATER);
    }

    public static Builder ice() {
        return TempBlock.builder(BlockType.ICE).bendable(true);
    }

    public static Builder air() {
        return TempBlock.builder(BlockType.AIR).bendable(true);
    }

    public static final class Builder {
        private final BlockState state;
        private DamageSource source;
        private boolean fixWater;
        private boolean bendable = false;
        private boolean weak = false;
        private long duration = 0L;

        private Builder(BlockState state) {
            this.state = state;
            this.fixWater = state.type().isAir();
        }

        public Builder fixWater(boolean fixWater) {
            this.fixWater = fixWater;
            return this;
        }

        public Builder bendable(boolean bendable) {
            this.bendable = bendable;
            return this;
        }

        public Builder weak(boolean weak) {
            this.weak = weak;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder ability(@Nullable Ability ability) {
            this.source = ability == null ? null : DamageSource.of(ability.user().name(), ability.description());
            return this;
        }

        private int validateDuration(Block block) {
            long time = this.duration;
            if (WaterMaterials.ICE_BENDABLE.isTagged(this.state) && block.world().dimension() == World.Dimension.NETHER) {
                time = FastMath.floor(0.5 * (double)time);
            }
            return MANAGER.fromMillis(time);
        }

        private BlockState calculateWaterData(Block above) {
            int level;
            Integer property = (Integer)above.state().property(BlockStateProperties.LEVEL);
            if (property != null) {
                level = property;
                if (level <= 7) {
                    level += 8;
                }
            } else {
                level = 8;
            }
            return MaterialUtil.waterData(level);
        }

        private BlockState correctData(Block block) {
            BlockState old;
            Boolean waterlogged;
            BlockState newData = this.state;
            boolean infiniteWater = false;
            if (this.fixWater) {
                infiniteWater = WorldUtil.isInfiniteWater(block);
                BlockType mat = infiniteWater ? BlockType.WATER : BlockType.AIR;
                Block above = block.offset(Direction.UP);
                newData = mat == BlockType.AIR && MaterialUtil.isWater(above) ? this.calculateWaterData(above) : mat.defaultState();
            }
            if ((waterlogged = (Boolean)(old = block.state()).property(BlockStateProperties.WATERLOGGED)) != null) {
                if (waterlogged.booleanValue() && newData.type().isAir()) {
                    return old.withProperty((Property)BlockStateProperties.WATERLOGGED, Boolean.valueOf(false));
                }
                if (infiniteWater || !waterlogged.booleanValue() && newData.type() == BlockType.WATER) {
                    return old.withProperty((Property)BlockStateProperties.WATERLOGGED, Boolean.valueOf(true));
                }
            }
            return newData;
        }

        public Optional<TempBlock> build(Block block) {
            BlockState newData;
            if (block.world().isBlockEntity(block)) {
                return Optional.empty();
            }
            BlockState current = block.state();
            if (current.matches(newData = this.correctData(block))) {
                return Optional.empty();
            }
            int ticks = this.validateDuration(block);
            TempBlock tb = MANAGER.get(block).orElse(null);
            if (tb != null) {
                TempBlockState first = tb.snapshots.peekFirst();
                if (first != null && newData.matches(first.state)) {
                    tb.revertFully();
                }
                if (tb.reverted || tb.snapshots.isEmpty()) {
                    MANAGER.removeEntry(block);
                    return Optional.empty();
                }
                tb.addState(newData, ticks, this);
                wheel.schedule(tb, ticks);
                return Optional.of(tb);
            }
            TempBlock result = new TempBlock(block, newData, ticks, this);
            return Optional.of(result);
        }
    }

    public static class Snapshot {
        protected final DamageSource source;
        protected final Block block;
        protected final BlockState state;
        protected final boolean bendable;
        protected boolean weak;

        private Snapshot(Block block, boolean bendable, boolean weak, @Nullable DamageSource source) {
            this.block = block;
            this.state = block.state();
            this.bendable = bendable;
            this.weak = weak;
            this.source = source;
        }

        private void revert() {
            this.block.world().loadChunkAsync(this.block).thenRun(() -> this.block.setState(this.state));
        }
    }

    private static final class TempBlockState
    extends Snapshot {
        private final int expirationTicks;

        private TempBlockState(Block block, int ticks, Builder builder) {
            super(block, builder.bendable, builder.weak, builder.source);
            this.expirationTicks = wheel.currentTick() + ticks;
        }
    }
}

