/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.user;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.ability.preset.PresetRegisterResult;
import me.moros.bending.api.config.attribute.AttributeHolder;
import me.moros.bending.api.event.ElementChangeEvent;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.platform.entity.DelegateLivingEntity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.temporal.Cooldown;
import me.moros.bending.api.user.BendingPlayer;
import me.moros.bending.api.user.SlotContainer;
import me.moros.bending.api.user.User;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.api.util.data.DataContainer;
import me.moros.bending.api.util.functional.BendingConditions;
import net.kyori.adventure.util.TriState;
import org.checkerframework.checker.nullness.qual.Nullable;

sealed class BendingUser
implements User,
DelegateLivingEntity
permits BendingPlayer {
    private final Game game;
    private final LivingEntity entity;
    private final DataContainer container;
    private final Map<String, TriState> virtualPermissions;
    private final AttributeHolder attributeMap;
    private final BiPredicate<User, AbilityDescription> condition;
    private final ElementSet elements;
    private final SlotContainer slots;
    private final Set<Preset> presets;
    private boolean canBend = true;
    private int index = 1;

    protected BendingUser(Game game, LivingEntity entity) {
        this.game = game;
        this.entity = entity;
        this.container = DataContainer.blocking(500L, TimeUnit.MILLISECONDS);
        this.virtualPermissions = new ConcurrentHashMap<String, TriState>();
        this.attributeMap = AttributeHolder.createEmpty();
        this.condition = BendingConditions.all();
        this.elements = ElementSet.mutable();
        this.slots = new SlotContainer();
        this.presets = ConcurrentHashMap.newKeySet(6);
    }

    @Override
    public LivingEntity entity() {
        return this.entity;
    }

    @Override
    public Game game() {
        return this.game;
    }

    @Override
    public DataContainer store() {
        return this.container;
    }

    @Override
    public Set<Element> elements() {
        return ElementSet.copyOf(this.elements);
    }

    protected boolean hasElements() {
        return !this.elements.isEmpty();
    }

    @Override
    public boolean hasElement(Element element) {
        return this.elements.contains((Object)element);
    }

    @Override
    public boolean hasElements(Collection<Element> elements) {
        return this.elements.containsAll(elements);
    }

    @Override
    public boolean addElement(Element element) {
        if (!this.hasElement(element) && this.game().eventBus().postElementChangeEvent(this, element, ElementChangeEvent.ElementAction.ADD)) {
            boolean empty = this.elements.isEmpty();
            this.elements.add(element);
            this.validatePassives();
            if (empty) {
                this.board();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeElement(Element element) {
        if (this.hasElement(element) && this.game().eventBus().postElementChangeEvent(this, element, ElementChangeEvent.ElementAction.REMOVE)) {
            this.elements.remove((Object)element);
            this.slots.validate((AbilityDescription desc) -> this.hasElements(desc.elements()));
            this.validateAbilities();
            this.board().updateAll();
            return true;
        }
        return false;
    }

    @Override
    public boolean chooseElement(Element element) {
        if (this.game().eventBus().postElementChangeEvent(this, element, ElementChangeEvent.ElementAction.CHOOSE)) {
            this.elements.set(ElementSet.of(element));
            Preset elementPreset = this.presetByName(element.name().toLowerCase(Locale.ROOT));
            if (elementPreset != null) {
                this.slots.fromPreset(elementPreset, this::validate);
            } else {
                this.slots.validate((AbilityDescription desc) -> this.hasElements(desc.elements()));
                this.validateAbilities();
            }
            this.board().updateAll();
            return true;
        }
        return false;
    }

    private void validateAbilities() {
        this.game.abilityManager(this.worldKey()).destroyUserInstances((User)this, a -> !this.hasElements(a.description().elements()));
        this.validatePassives();
    }

    private void validatePassives() {
        this.game.abilityManager(this.worldKey()).createPassives(this);
    }

    @Override
    public Preset slots() {
        return this.slots.toPreset();
    }

    @Override
    public boolean bindPreset(Preset preset) {
        if (this.game().eventBus().postMultiBindChangeEvent(this, preset)) {
            Preset oldBinds = this.slots();
            this.slots.fromPreset(preset, this::validate);
            this.board().updateAll();
            return !oldBinds.matchesBinds(this.slots.getArray());
        }
        return false;
    }

    @Override
    public @Nullable AbilityDescription boundAbility(int slot) {
        if (slot < 1 || slot > 9) {
            return null;
        }
        return this.slots.get(slot - 1);
    }

    @Override
    public void bindAbility(int slot, @Nullable AbilityDescription desc) {
        if (slot < 1 || slot > 9 || desc != null && !desc.canBind()) {
            return;
        }
        if (this.game().eventBus().postSingleBindChangeEvent(this, slot, desc)) {
            this.slots.set(slot - 1, desc);
            this.board().updateAll();
        }
    }

    @Override
    public int currentSlot() {
        return this.index + 1;
    }

    @Override
    public void currentSlot(int slot) {
        if (slot >= 1 && slot <= 9) {
            this.index = slot - 1;
        }
    }

    @Override
    public boolean onCooldown(AbilityDescription desc) {
        return Cooldown.MANAGER.isTemp(Cooldown.of(this, desc));
    }

    @Override
    public boolean addCooldown(AbilityDescription desc, long duration) {
        if (duration > 0L && this.game().eventBus().postCooldownAddEvent(this, desc, duration)) {
            Cooldown.of(this, desc, () -> this.onRemoveCooldown(desc), duration);
            this.updateBoard(desc, true);
            return true;
        }
        return false;
    }

    private void onRemoveCooldown(AbilityDescription desc) {
        if (this.valid()) {
            this.updateBoard(desc, false);
            this.game().eventBus().postCooldownRemoveEvent(this, desc);
        }
    }

    @Override
    public boolean canBend(AbilityDescription desc) {
        return this.condition.test(this, desc);
    }

    @Override
    public boolean canBend() {
        return this.canBend;
    }

    @Override
    public boolean toggleBending() {
        this.canBend ^= true;
        if (!this.canBend) {
            this.game.abilityManager(this.worldKey()).destroyUserInstances((User)this, a -> !a.description().isActivatedBy(Activation.PASSIVE));
        }
        this.board();
        return this.canBend;
    }

    @Override
    public Board board() {
        return Board.dummy();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.virtualPermissions.get(permission) != TriState.FALSE;
    }

    @Override
    public TriState setPermission(String permission, TriState state) {
        TriState prev = state == TriState.NOT_SET ? this.virtualPermissions.remove(permission) : this.virtualPermissions.put(permission, state);
        return prev == null ? TriState.NOT_SET : prev;
    }

    @Override
    public AttributeHolder attributeModifiers() {
        return this.attributeMap;
    }

    private void updateBoard(@Nullable AbilityDescription desc, boolean cooldown) {
        if (desc != null && !desc.canBind()) {
            this.board().updateMisc(desc, cooldown);
        } else {
            this.board().updateAll();
        }
    }

    private boolean validate(AbilityDescription desc) {
        return desc.canBind() && this.hasElements(desc.elements()) && this.hasPermission(desc);
    }

    @Override
    public Set<Preset> presets() {
        return Set.copyOf(this.presets);
    }

    @Override
    public int presetSize() {
        return this.presets.size();
    }

    @Override
    public @Nullable Preset presetByName(String name) {
        return this.presets.stream().filter(p -> p.name().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    @Override
    public PresetRegisterResult addPreset(Preset preset) {
        String n;
        block5: {
            block4: {
                n = preset.name();
                if (this.presets.contains(preset)) break block4;
                if (!this.presets.stream().map(Preset::name).anyMatch(n::equalsIgnoreCase)) break block5;
            }
            return PresetRegisterResult.EXISTS;
        }
        if (n.isEmpty() || preset.isEmpty() || !this.game().eventBus().postPresetRegisterEvent(this, preset)) {
            return PresetRegisterResult.CANCELLED;
        }
        this.presets.add(preset);
        return PresetRegisterResult.SUCCESS;
    }

    @Override
    public boolean removePreset(Preset preset) {
        if (this.presets.remove(preset)) {
            this.game().eventBus().postPresetUnregisterEvent(this, preset);
            return true;
        }
        return false;
    }

    @Override
    public BenderProfile toProfile() {
        return BenderProfile.of(this.uuid(), !this.store().has(Board.HIDDEN), this.elements(), this.slots(), this.presets);
    }

    @Override
    public boolean fromProfile(BenderProfile profile) {
        if (!this.uuid().equals(profile.uuid()) || !this.valid()) {
            return false;
        }
        if (this.elements.set(profile.elements())) {
            this.validateAbilities();
        }
        this.slots.fromPreset(profile.slots(), this::validate);
        this.presets.clear();
        this.presets.addAll(profile.presets().values());
        if (profile.board()) {
            Tasker.sync().submit(() -> this.board().updateAll());
        } else {
            this.store().add(Board.HIDDEN, true);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BendingUser) {
            BendingUser other = (BendingUser)obj;
            return this.entity().equals(other.entity());
        }
        return false;
    }

    public int hashCode() {
        return this.entity().hashCode();
    }
}

