/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.user;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.protection.ProtectionCache;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.AttributeUser;
import me.moros.bending.api.user.BendingPlayer;
import me.moros.bending.api.user.BendingUser;
import me.moros.bending.api.user.ElementUser;
import me.moros.bending.api.user.PresetUser;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.GridIterator;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataContainer;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import net.kyori.adventure.util.TriState;
import org.checkerframework.checker.nullness.qual.Nullable;

public sealed interface User
extends LivingEntity,
ElementUser,
AttributeUser,
PresetUser
permits BendingUser {
    public Game game();

    public DataContainer store();

    default public boolean isSpectator() {
        return false;
    }

    public boolean onCooldown(AbilityDescription var1);

    public boolean addCooldown(AbilityDescription var1, long var2);

    public Preset slots();

    public boolean bindPreset(Preset var1);

    public void bindAbility(int var1, @Nullable AbilityDescription var2);

    public @Nullable AbilityDescription boundAbility(int var1);

    public int currentSlot();

    public void currentSlot(int var1);

    default public @Nullable AbilityDescription selectedAbility() {
        return this.boundAbility(this.currentSlot());
    }

    default public boolean hasAbilitySelected(String key) {
        AbilityDescription selected = this.selectedAbility();
        return selected != null && selected.key().equals((Object)KeyUtil.BENDING_KEY_MAPPER.apply(key.toLowerCase(Locale.ROOT)));
    }

    default public void clearSlot(int slot) {
        this.bindAbility(slot, null);
    }

    public boolean canBend(AbilityDescription var1);

    public boolean canBend();

    public boolean toggleBending();

    public Board board();

    default public boolean hasPermission(AbilityDescription desc) {
        return desc.permissions().stream().allMatch(this::hasPermission);
    }

    public boolean hasPermission(String var1);

    public TriState setPermission(String var1, TriState var2);

    default public boolean canBuild() {
        return this.canBuild(this.world().blockAt(this.location()));
    }

    default public boolean canBuild(Vector3d position) {
        return this.canBuild(this.world().blockAt(position));
    }

    default public boolean canBuild(Block block) {
        return ProtectionCache.INSTANCE.canBuild(this, block);
    }

    default public @Nullable Block find(double range, Predicate<Block> predicate) {
        GridIterator it = GridIterator.create(this.eyeLocation(), this.direction(), Math.clamp((long)FastMath.ceil(range), 1, 100));
        while (it.hasNext()) {
            Block block = this.world().blockAt(it.next());
            if (block.type().isAir()) continue;
            if (predicate.test(block) && TempBlock.isBendable(block) && this.canBuild(block)) {
                return block;
            }
            if (!block.type().isCollidable()) continue;
            break;
        }
        return null;
    }

    public BenderProfile toProfile();

    public boolean fromProfile(BenderProfile var1);

    public static Optional<User> create(Game game, LivingEntity entity, BenderProfile profile) {
        return User.create(game, entity, CompletableFuture.completedFuture(profile));
    }

    public static Optional<User> create(Game game, LivingEntity entity, CompletableFuture<BenderProfile> profileFuture) {
        Objects.requireNonNull(game);
        Objects.requireNonNull(profileFuture);
        if (!Registries.BENDERS.containsKey(entity.uuid())) {
            BendingUser user;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                v0 = new BendingPlayer(game, player);
            } else {
                v0 = user = new BendingUser(game, entity);
            }
            if (Registries.BENDERS.register(user)) {
                profileFuture.thenAccept(user::fromProfile);
                return Optional.of(user);
            }
        }
        return Optional.empty();
    }
}

