/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.Objects;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.entity.player.Player;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;

public final class BendingBar
implements Updatable {
    private final BossBar bar;
    private final Audience audience;
    private final int duration;
    private int ticks;

    private BendingBar(BossBar bar, Audience audience, int duration) {
        this.bar = bar;
        this.audience = audience;
        this.duration = duration;
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.ticks >= this.duration) {
            this.onRemove();
            return Updatable.UpdateResult.REMOVE;
        }
        float factor = Math.clamp((float)(this.duration - this.ticks) / (float)this.duration, 0.0f, 1.0f);
        this.bar.progress(factor);
        if (this.ticks++ == 0) {
            this.audience.showBossBar(this.bar);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    public void onRemove() {
        this.audience.hideBossBar(this.bar);
    }

    public static BendingBar of(BossBar bar, Player target, int ticks) {
        Objects.requireNonNull(bar);
        Objects.requireNonNull(target);
        return new BendingBar(bar, (Audience)target, ticks);
    }
}

