/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public final class GridIterator
implements Iterator<Vector3d> {
    private static final double BIG_DELTA = 1.0E30;
    private static final double EPSILON = 1.0E-10;
    private final short[] signums = new short[3];
    private final Position end;
    private boolean foundEnd;
    double sideDistX;
    double sideDistY;
    double sideDistZ;
    private final double deltaDistX;
    private final double deltaDistY;
    private final double deltaDistZ;
    int mapX;
    int mapY;
    int mapZ;
    private final Deque<Vector3d> extraPoints = new ArrayDeque<Vector3d>();

    private GridIterator(Vector3d origin, Vector3d dir, double maxDistance) {
        this.end = ((Vector3d)origin.add((Position)dir.multiply(maxDistance))).toVector3i();
        this.mapX = origin.blockX();
        this.mapY = origin.blockY();
        this.mapZ = origin.blockZ();
        this.signums[0] = (short)Math.signum(dir.x());
        this.signums[1] = (short)Math.signum(dir.y());
        this.signums[2] = (short)Math.signum(dir.z());
        this.deltaDistX = dir.x() == 0.0 ? 1.0E30 : Math.abs(1.0 / dir.x());
        this.deltaDistY = dir.y() == 0.0 ? 1.0E30 : Math.abs(1.0 / dir.y());
        this.deltaDistZ = dir.z() == 0.0 ? 1.0E30 : Math.abs(1.0 / dir.z());
        this.sideDistX = dir.x() < 0.0 ? (origin.x() - (double)this.mapX) * this.deltaDistX : ((double)this.mapX + 1.0 - origin.x()) * this.deltaDistX;
        this.sideDistY = dir.y() < 0.0 ? (origin.y() - (double)this.mapY) * this.deltaDistY : ((double)this.mapY + 1.0 - origin.y()) * this.deltaDistY;
        this.sideDistZ = dir.z() < 0.0 ? (origin.z() - (double)this.mapZ) * this.deltaDistZ : ((double)this.mapZ + 1.0 - origin.z()) * this.deltaDistZ;
    }

    private boolean reachedEnd(Position p) {
        return p.blockX() == this.end.blockX() && p.blockY() == this.end.blockY() && p.blockZ() == this.end.blockZ();
    }

    @Override
    public boolean hasNext() {
        return !this.foundEnd;
    }

    @Override
    public Vector3d next() {
        boolean needsZ;
        double closest;
        if (this.foundEnd) {
            throw new NoSuchElementException();
        }
        if (!this.extraPoints.isEmpty()) {
            Vector3d res = this.extraPoints.poll();
            if (this.reachedEnd(res)) {
                this.foundEnd = true;
            }
            return res;
        }
        Vector3d current = Vector3d.of(this.mapX, this.mapY, this.mapZ);
        if (this.reachedEnd(current)) {
            this.foundEnd = true;
        }
        boolean needsX = this.sideDistX - (closest = Math.min(this.sideDistX, Math.min(this.sideDistY, this.sideDistZ))) < 1.0E-10;
        boolean needsY = this.sideDistY - closest < 1.0E-10;
        boolean bl = needsZ = this.sideDistZ - closest < 1.0E-10;
        if (needsZ) {
            this.sideDistZ += this.deltaDistZ;
            this.mapZ += this.signums[2];
        }
        if (needsX) {
            this.sideDistX += this.deltaDistX;
            this.mapX += this.signums[0];
        }
        if (needsY) {
            this.sideDistY += this.deltaDistY;
            this.mapY += this.signums[1];
        }
        if (needsX && needsY && needsZ) {
            this.extraPoints.add(Vector3d.of((double)this.signums[0] + current.x(), current.y(), current.z()));
            this.extraPoints.add(Vector3d.of(current.x(), (double)this.signums[1] + current.y(), current.z()));
            this.extraPoints.add(Vector3d.of(current.x(), current.y(), (double)this.signums[2] + current.z()));
        } else if (needsX && needsY) {
            this.extraPoints.add(Vector3d.of((double)this.signums[0] + current.x(), current.y(), current.z()));
            this.extraPoints.add(Vector3d.of(current.x(), (double)this.signums[1] + current.y(), current.z()));
        } else if (needsX && needsZ) {
            this.extraPoints.add(Vector3d.of((double)this.signums[0] + current.x(), current.y(), current.z()));
            this.extraPoints.add(Vector3d.of(current.x(), current.y(), (double)this.signums[2] + current.z()));
        } else if (needsY && needsZ) {
            this.extraPoints.add(Vector3d.of(current.x(), (double)this.signums[1] + current.y(), current.z()));
            this.extraPoints.add(Vector3d.of(current.x(), current.y(), (double)this.signums[2] + current.z()));
        }
        return current;
    }

    public static GridIterator create(Vector3d start, Vector3d dir, double length) {
        return new GridIterator(start, dir.normalize(), length);
    }
}

