/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.data;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.data.BlockingDataContainer;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.data.SimpleDataContainer;

public interface DataContainer
extends DataHolder {
    public <T> boolean canEdit(DataKey<T> var1);

    default public <T> boolean offer(DataKey<T> key, T value) {
        if (this.canEdit(key)) {
            this.add(key, value);
            return true;
        }
        return false;
    }

    public <T extends Enum<T>> T toggle(DataKey<T> var1, T var2);

    public boolean isEmpty();

    public static DataContainer simple() {
        return new SimpleDataContainer(new ConcurrentHashMap());
    }

    public static DataContainer blocking(long cooldown, TimeUnit unit) {
        return new BlockingDataContainer(new ConcurrentHashMap(), new ExpiringSet(cooldown, unit));
    }
}

