/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.collision.CollisionPair;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.common.ability.air.AirBlade;
import me.moros.bending.common.ability.air.AirBlast;
import me.moros.bending.common.ability.air.AirBreath;
import me.moros.bending.common.ability.air.AirBurst;
import me.moros.bending.common.ability.air.AirPunch;
import me.moros.bending.common.ability.air.AirScooter;
import me.moros.bending.common.ability.air.AirShield;
import me.moros.bending.common.ability.air.AirSpout;
import me.moros.bending.common.ability.air.AirSwipe;
import me.moros.bending.common.ability.air.Tornado;
import me.moros.bending.common.ability.air.passive.AirAgility;
import me.moros.bending.common.ability.air.passive.GracefulDescent;
import me.moros.bending.common.ability.air.sequence.AirWheel;
import me.moros.bending.common.ability.avatar.AvatarState;
import me.moros.bending.common.ability.earth.Bulwark;
import me.moros.bending.common.ability.earth.Catapult;
import me.moros.bending.common.ability.earth.Collapse;
import me.moros.bending.common.ability.earth.EarthArmor;
import me.moros.bending.common.ability.earth.EarthBlast;
import me.moros.bending.common.ability.earth.EarthGlove;
import me.moros.bending.common.ability.earth.EarthLine;
import me.moros.bending.common.ability.earth.EarthShot;
import me.moros.bending.common.ability.earth.EarthSmash;
import me.moros.bending.common.ability.earth.EarthSurf;
import me.moros.bending.common.ability.earth.EarthTunnel;
import me.moros.bending.common.ability.earth.LavaDisk;
import me.moros.bending.common.ability.earth.LavaFlux;
import me.moros.bending.common.ability.earth.MetalCable;
import me.moros.bending.common.ability.earth.RaiseEarth;
import me.moros.bending.common.ability.earth.Shockwave;
import me.moros.bending.common.ability.earth.passive.DensityShift;
import me.moros.bending.common.ability.earth.passive.EarthCling;
import me.moros.bending.common.ability.earth.passive.FerroControl;
import me.moros.bending.common.ability.earth.passive.Locksmithing;
import me.moros.bending.common.ability.earth.sequence.EarthPillars;
import me.moros.bending.common.ability.earth.sequence.EarthShards;
import me.moros.bending.common.ability.fire.Blaze;
import me.moros.bending.common.ability.fire.Combustion;
import me.moros.bending.common.ability.fire.FireBlast;
import me.moros.bending.common.ability.fire.FireBreath;
import me.moros.bending.common.ability.fire.FireBurst;
import me.moros.bending.common.ability.fire.FireJet;
import me.moros.bending.common.ability.fire.FireShield;
import me.moros.bending.common.ability.fire.FireWall;
import me.moros.bending.common.ability.fire.FlameRush;
import me.moros.bending.common.ability.fire.HeatControl;
import me.moros.bending.common.ability.fire.Lightning;
import me.moros.bending.common.ability.fire.sequence.FireKick;
import me.moros.bending.common.ability.fire.sequence.FireSpin;
import me.moros.bending.common.ability.fire.sequence.FireWheel;
import me.moros.bending.common.ability.water.BloodBending;
import me.moros.bending.common.ability.water.FrostBreath;
import me.moros.bending.common.ability.water.HealingWaters;
import me.moros.bending.common.ability.water.IceCrawl;
import me.moros.bending.common.ability.water.IceSpike;
import me.moros.bending.common.ability.water.IceWall;
import me.moros.bending.common.ability.water.OctopusForm;
import me.moros.bending.common.ability.water.PhaseChange;
import me.moros.bending.common.ability.water.Torrent;
import me.moros.bending.common.ability.water.WaterBubble;
import me.moros.bending.common.ability.water.WaterManipulation;
import me.moros.bending.common.ability.water.WaterRing;
import me.moros.bending.common.ability.water.WaterSpout;
import me.moros.bending.common.ability.water.WaterWave;
import me.moros.bending.common.ability.water.passive.FastSwim;
import me.moros.bending.common.ability.water.passive.HydroSink;
import me.moros.bending.common.ability.water.sequence.Iceberg;
import me.moros.bending.common.ability.water.sequence.WaterGimbal;
import me.moros.bending.common.config.ConfigManager;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.common.util.ReflectionUtil;
import net.kyori.adventure.key.Key;

public final class AbilityInitializer
implements Initializer {
    private static final Key DUMMY = KeyUtil.simple("dummy");
    public static final Container<Key> spouts = AbilityInitializer.wrap("AirSpout", "WaterSpout");
    public static final Container<Key> blasts = AbilityInitializer.wrap("EarthBlast", "FireBlast", "WaterManipulation");
    public static final Container<Key> layer0 = AbilityInitializer.wrap("EarthGlove", "MetalCable");
    public static final Container<Key> layer1 = AbilityInitializer.wrap("AirSwipe", "AirBurst", "EarthBlast", "FireBlast", "FireBurst", "WaterManipulation");
    public static final Container<Key> layer2 = AbilityInitializer.wrap("AirWheel", "AirPunch", "AirBlade", "FireKick", "FireSpin", "FireWheel", "FlameRush");
    public static final Container<Key> layer3 = AbilityInitializer.wrap("LavaDisk", "EarthSmash", "Combustion");
    private final Collection<AbilityDescription> abilities = new ArrayList<AbilityDescription>(64);

    private static Container<Key> wrap(String ... abilities) {
        Set keys = Stream.of(abilities).map(AbilityInitializer::key).collect(Collectors.toSet());
        return Container.create(DUMMY, keys);
    }

    private static Key key(String ability) {
        return Objects.requireNonNull(KeyUtil.BENDING_KEY_MAPPER.apply(ability.toLowerCase(Locale.ROOT)));
    }

    @Override
    public void init() {
        this.initAir();
        this.initWater();
        this.initEarth();
        this.initFire();
        this.initAvatar();
        Registries.ABILITIES.register(this.abilities);
        Registries.COLLISIONS.register(this.buildCollisions());
    }

    private Collection<CollisionPair> buildCollisions() {
        ArrayList<Key> shieldCollisions = new ArrayList<Key>();
        layer0.forEach(shieldCollisions::add);
        layer1.forEach(shieldCollisions::add);
        shieldCollisions.add(AbilityInitializer.key("EarthShot"));
        return CollisionPair.builder().layer(layer0).layer(layer1).layer(layer2).layer(layer3).add(spouts, layer1, true, false).add(spouts, AbilityInitializer.wrap("LavaDisk", "EarthSmash", "FlameRush"), true, false).add(shieldCollisions, AbilityInitializer.wrap("AirShield", "FireWall"), true, false).add(AbilityInitializer.key("Shockwave"), blasts, false, true).add(AbilityInitializer.key("FireShield"), blasts, false, true).add(AbilityInitializer.key("FireShield"), AbilityInitializer.key("Combustion"), true, true).add(AbilityInitializer.key("FrostBreath"), blasts, false, true).add(AbilityInitializer.key("FireBreath"), blasts, false, true).add(AbilityInitializer.key("Lightning"), AbilityInitializer.key("MetalCable"), true, false).add(AbilityInitializer.key("Lightning"), AbilityInitializer.key("EarthSmash"), false, true).add(AbilityInitializer.key("Lightning"), AbilityInitializer.key("EarthBlast"), false, true).add(AbilityInitializer.key("FireBreath"), AbilityInitializer.key("EarthSmash"), false, false).add(AbilityInitializer.key("FrostBreath"), AbilityInitializer.key("EarthSmash"), false, false).add(AbilityInitializer.key("FrostBreath"), AbilityInitializer.key("FireBreath"), true, true).add(AbilityInitializer.key("FrostBreath"), AbilityInitializer.key("AirShield"), true, true).add(AbilityInitializer.key("IceCrawl"), AbilityInitializer.key("EarthLine"), true, false).build();
    }

    private void initAir() {
        this.abilities.add(AbilityDescription.builder("AirAgility", AirAgility::new).element(Element.AIR).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        this.abilities.add(AbilityDescription.builder("GracefulDescent", GracefulDescent::new).element(Element.AIR).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        this.abilities.add(AbilityDescription.builder("AirSwipe", AirSwipe::new).element(Element.AIR).activation(Activation.ATTACK, Activation.SNEAK).build());
        this.abilities.add(AbilityDescription.builder("AirBlast", AirBlast::new).element(Element.AIR).activation(Activation.ATTACK, Activation.SNEAK_RELEASE).build());
        this.abilities.add(AbilityDescription.builder("AirBurst", AirBurst::new).element(Element.AIR).activation(Activation.ATTACK, Activation.SNEAK, Activation.FALL).build());
        this.abilities.add(AbilityDescription.builder("AirShield", AirShield::new).element(Element.AIR).activation(Activation.SNEAK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("AirSpout", AirSpout::new).element(Element.AIR).activation(Activation.ATTACK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("AirPunch", AirPunch::new).element(Element.AIR).activation(Activation.ATTACK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("AirBreath", AirBreath::new).element(Element.AIR).activation(Activation.SNEAK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("Tornado", Tornado::new).element(Element.AIR).activation(Activation.SNEAK, new Activation[0]).build());
        AbilityDescription airBlade = AbilityDescription.builder("AirBlade", AirBlade::new).element(Element.AIR).activation(Activation.SNEAK, new Activation[0]).build();
        this.abilities.add(airBlade);
        AbilityDescription airScooter = AbilityDescription.builder("AirScooter", AirScooter::new).element(Element.AIR).activation(Activation.ATTACK, new Activation[0]).build();
        this.abilities.add(airScooter);
        AbilityDescription.Sequence airWheel = AbilityDescription.builder("AirWheel", AirWheel::new).element(Element.AIR).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(airScooter, Activation.SNEAK, Activation.SNEAK_RELEASE, Activation.SNEAK, Activation.SNEAK_RELEASE).add(airBlade, Activation.ATTACK));
        this.abilities.add(airWheel);
    }

    private void initWater() {
        this.abilities.add(AbilityDescription.builder("FastSwim", FastSwim::new).element(Element.WATER).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        this.abilities.add(AbilityDescription.builder("HydroSink", HydroSink::new).element(Element.WATER).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        AbilityDescription waterManipulation = AbilityDescription.builder("WaterManipulation", WaterManipulation::new).element(Element.WATER).activation(Activation.SNEAK, Activation.ATTACK).bypassCooldown(true).build();
        this.abilities.add(waterManipulation);
        this.abilities.add(AbilityDescription.builder("WaterSpout", WaterSpout::new).element(Element.WATER).activation(Activation.ATTACK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("HealingWaters", HealingWaters::new).element(Element.WATER).activation(Activation.SNEAK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("BloodBending", BloodBending::new).element(Element.WATER).activation(Activation.SNEAK, Activation.ATTACK).build());
        this.abilities.add(AbilityDescription.builder("WaterBubble", WaterBubble::new).element(Element.WATER).activation(Activation.SNEAK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("OctopusForm", OctopusForm::new).element(Element.WATER).activation(Activation.ATTACK, new Activation[0]).build());
        AbilityDescription waterRing = AbilityDescription.builder("WaterRing", WaterRing::new).element(Element.WATER).activation(Activation.ATTACK, new Activation[0]).build();
        this.abilities.add(waterRing);
        AbilityDescription waterWave = AbilityDescription.builder("WaterWave", WaterWave::new).element(Element.WATER).activation(Activation.PASSIVE, Activation.SNEAK).canBind(false).build();
        this.abilities.add(waterWave);
        AbilityDescription torrent = AbilityDescription.builder("Torrent", Torrent::new).element(Element.WATER).activation(Activation.ATTACK, new Activation[0]).bypassCooldown(true).build();
        this.abilities.add(torrent);
        AbilityDescription phaseChange = AbilityDescription.builder("PhaseChange", PhaseChange::new).element(Element.WATER).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(phaseChange);
        AbilityDescription iceCrawl = AbilityDescription.builder("IceCrawl", IceCrawl::new).element(Element.WATER).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(iceCrawl);
        AbilityDescription iceSpike = AbilityDescription.builder("IceSpike", IceSpike::new).element(Element.WATER).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(iceSpike);
        this.abilities.add(AbilityDescription.builder("IceWall", IceWall::new).element(Element.WATER).activation(Activation.SNEAK, new Activation[0]).bypassCooldown(true).build());
        this.abilities.add(AbilityDescription.builder("FrostBreath", FrostBreath::new).element(Element.WATER).activation(Activation.SNEAK, new Activation[0]).build());
        AbilityDescription.Sequence waterGimbal = AbilityDescription.builder("WaterGimbal", WaterGimbal::new).element(Element.WATER).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(waterRing, Activation.SNEAK, Activation.SNEAK_RELEASE, Activation.SNEAK, Activation.SNEAK_RELEASE).add(torrent, Activation.SNEAK));
        this.abilities.add(waterGimbal);
        AbilityDescription.Sequence iceberg = AbilityDescription.builder("Iceberg", Iceberg::new).element(Element.WATER).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(phaseChange, Activation.SNEAK).add(iceSpike, Activation.SNEAK_RELEASE).add(phaseChange, Activation.SNEAK).add(iceSpike, Activation.SNEAK_RELEASE, Activation.SNEAK));
        this.abilities.add(iceberg);
    }

    private void initEarth() {
        this.abilities.add(AbilityDescription.builder("DensityShift", DensityShift::new).element(Element.EARTH).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        this.abilities.add(AbilityDescription.builder("EarthCling", EarthCling::new).element(Element.EARTH).activation(Activation.PASSIVE, new Activation[0]).canBind(false).build());
        this.abilities.add(AbilityDescription.builder("FerroControl", FerroControl::new).element(Element.EARTH).activation(Activation.PASSIVE, new Activation[0]).canBind(false).require(FeaturePermissions.METAL).build());
        this.abilities.add(AbilityDescription.builder("Locksmithing", Locksmithing::new).element(Element.EARTH).activation(Activation.PASSIVE, new Activation[0]).canBind(false).require(FeaturePermissions.METAL).build());
        this.abilities.add(AbilityDescription.builder("EarthBlast", EarthBlast::new).element(Element.EARTH).activation(Activation.SNEAK, Activation.ATTACK).bypassCooldown(true).build());
        this.abilities.add(AbilityDescription.builder("EarthSmash", EarthSmash::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).bypassCooldown(true).build());
        this.abilities.add(AbilityDescription.builder("EarthShot", EarthShot::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).build());
        this.abilities.add(AbilityDescription.builder("EarthLine", EarthLine::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).bypassCooldown(true).build());
        this.abilities.add(AbilityDescription.builder("EarthTunnel", EarthTunnel::new).element(Element.EARTH).activation(Activation.SNEAK, new Activation[0]).build());
        AbilityDescription earthArmor = AbilityDescription.builder("EarthArmor", EarthArmor::new).element(Element.EARTH).activation(Activation.ATTACK, new Activation[0]).build();
        this.abilities.add(earthArmor);
        AbilityDescription earthGlove = AbilityDescription.builder("EarthGlove", EarthGlove::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).bypassCooldown(true).build();
        this.abilities.add(earthGlove);
        this.abilities.add(AbilityDescription.builder("RaiseEarth", RaiseEarth::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).build());
        AbilityDescription collapse = AbilityDescription.builder("Collapse", Collapse::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(collapse);
        AbilityDescription catapult = AbilityDescription.builder("Catapult", Catapult::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(catapult);
        AbilityDescription shockwave = AbilityDescription.builder("Shockwave", Shockwave::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK, Activation.FALL).build();
        this.abilities.add(shockwave);
        this.abilities.add(AbilityDescription.builder("EarthSurf", EarthSurf::new).element(Element.EARTH).activation(Activation.SNEAK, Activation.FALL).build());
        this.abilities.add(AbilityDescription.builder("MetalCable", MetalCable::new).element(Element.EARTH).activation(Activation.ATTACK, Activation.SNEAK).bypassCooldown(true).require(FeaturePermissions.METAL).build());
        this.abilities.add(AbilityDescription.builder("LavaDisk", LavaDisk::new).element(Element.EARTH).activation(Activation.SNEAK, new Activation[0]).require(FeaturePermissions.LAVA).build());
        this.abilities.add(AbilityDescription.builder("LavaFlux", LavaFlux::new).element(Element.EARTH).activation(Activation.SNEAK, new Activation[0]).require(FeaturePermissions.LAVA).build());
        AbilityDescription.Sequence bulwark = AbilityDescription.builder("Bulwark", Bulwark::new).element(Element.EARTH).activation(Activation.SEQUENCE, new Activation[0]).hidden(true).buildSequence(steps -> steps.add(earthArmor, Activation.SNEAK, Activation.SNEAK_RELEASE));
        this.abilities.add(bulwark);
        AbilityDescription.Sequence earthPillars = AbilityDescription.builder("EarthPillars", EarthPillars::new).element(Element.EARTH).activation(Activation.SEQUENCE, Activation.FALL).buildSequence(steps -> steps.add(shockwave, Activation.SNEAK).add(catapult, Activation.SNEAK_RELEASE));
        this.abilities.add(earthPillars);
        AbilityDescription.Sequence earthShards = AbilityDescription.builder("EarthShards", EarthShards::new).element(Element.EARTH).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(earthGlove, Activation.SNEAK).add(collapse, Activation.SNEAK_RELEASE, Activation.SNEAK).add(earthGlove, Activation.SNEAK_RELEASE));
        this.abilities.add(earthShards);
    }

    private void initFire() {
        AbilityDescription fireBlast = AbilityDescription.builder("FireBlast", FireBlast::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(fireBlast);
        this.abilities.add(AbilityDescription.builder("FireBurst", FireBurst::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build());
        this.abilities.add(AbilityDescription.builder("FlameRush", FlameRush::new).element(Element.FIRE).activation(Activation.SNEAK, new Activation[0]).build());
        AbilityDescription heatControl = AbilityDescription.builder("HeatControl", HeatControl::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(heatControl);
        this.abilities.add(AbilityDescription.builder("Blaze", Blaze::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build());
        this.abilities.add(AbilityDescription.builder("FireBreath", FireBreath::new).element(Element.FIRE).activation(Activation.SNEAK, new Activation[0]).build());
        AbilityDescription fireShield = AbilityDescription.builder("FireShield", FireShield::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build();
        this.abilities.add(fireShield);
        AbilityDescription fireJet = AbilityDescription.builder("FireJet", FireJet::new).element(Element.FIRE).activation(Activation.ATTACK, new Activation[0]).build();
        this.abilities.add(fireJet);
        AbilityDescription fireWall = AbilityDescription.builder("FireWall", FireWall::new).element(Element.FIRE).activation(Activation.ATTACK, new Activation[0]).build();
        this.abilities.add(fireWall);
        this.abilities.add(AbilityDescription.builder("Lightning", Lightning::new).element(Element.FIRE).activation(Activation.SNEAK, new Activation[0]).build());
        this.abilities.add(AbilityDescription.builder("Combustion", Combustion::new).element(Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).bypassCooldown(true).build());
        AbilityDescription.Sequence fireKick = AbilityDescription.builder("FireKick", FireKick::new).element(Element.FIRE).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(fireBlast, Activation.ATTACK, Activation.ATTACK, Activation.SNEAK, Activation.ATTACK));
        this.abilities.add(fireKick);
        AbilityDescription.Sequence fireSpin = AbilityDescription.builder("FireSpin", FireSpin::new).element(Element.FIRE).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(fireBlast, Activation.ATTACK, Activation.ATTACK).add(fireShield, Activation.ATTACK, Activation.SNEAK, Activation.SNEAK_RELEASE));
        this.abilities.add(fireSpin);
        AbilityDescription.Sequence fireWheel = AbilityDescription.builder("FireWheel", FireWheel::new).element(Element.FIRE).activation(Activation.SEQUENCE, new Activation[0]).buildSequence(steps -> steps.add(fireShield, Activation.SNEAK, Activation.INTERACT_BLOCK, Activation.INTERACT_BLOCK, Activation.SNEAK_RELEASE));
        this.abilities.add(fireWheel);
    }

    private void initAvatar() {
        this.abilities.add(AbilityDescription.builder("AvatarState", AvatarState::new).element(Element.AIR, Element.WATER, Element.EARTH, Element.FIRE).activation(Activation.ATTACK, Activation.SNEAK).build());
    }

    public static void initConfigs() {
        Registries.ABILITIES.stream().map(AbilityDescription::createAbility).map(a -> ReflectionUtil.findInnerClass(a, Configurable.class)).filter(Objects::nonNull).forEach(ConfigManager::cache);
    }
}

