/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractSpout;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.common.ability.SpoutAbility;
import me.moros.math.Vector3d;

public class AirSpout
extends AbilityInstance
implements SpoutAbility {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private AbstractSpout spout;

    public AirSpout(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).destroyUserInstances(user, AirSpout.class)) {
            return false;
        }
        if (Policies.UNDER_WATER.test(user, this.description()) || Policies.UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        double h = this.userConfig.height + 2.0;
        if (AbstractSpout.blockCast(user.block(), h) == null) {
            return false;
        }
        this.removalPolicy = Policies.defaults();
        this.spout = new Spout();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || this.user.eyeBlock().type().isLiquid()) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.spout.update();
    }

    @Override
    public void onDestroy() {
        this.spout.onDestroy();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.spout.collider());
    }

    @Override
    public void handleMovement(Vector3d velocity) {
        if (this.spout != null) {
            this.spout.limitVelocity(velocity, this.userConfig.maxSpeed);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2000L;
        @Modifiable(value=Attribute.HEIGHT)
        private double height = 11.0;
        @Modifiable(value=Attribute.SPEED)
        private double maxSpeed = 0.2;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airspout");
        }
    }

    private final class Spout
    extends AbstractSpout {
        private long nextRenderTime;

        private Spout() {
            super(AirSpout.this.user, AirSpout.this.userConfig.height);
            this.nextRenderTime = 0L;
        }

        @Override
        public void render(Vector3d location) {
            long time = System.currentTimeMillis();
            if (time < this.nextRenderTime) {
                return;
            }
            int i = 0;
            while ((double)i < this.distance) {
                ParticleBuilder.air(AirSpout.this.user.location().subtract(0.0, i, 0.0)).count(2).offset(0.4).spawn(AirSpout.this.user.world());
                ++i;
            }
            this.nextRenderTime = time + 100L;
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(8) == 0) {
                SoundEffect.AIR.play(AirSpout.this.user.world(), location);
            }
        }
    }
}

