/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Pillar;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.common.ability.earth.Collapse;
import me.moros.bending.common.ability.earth.RaiseEarth;

public class Bulwark
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Updatable wall;
    private final Collection<Block> bases = new ArrayList<Block>();
    private boolean collapsing = false;
    private long startTime;

    public Bulwark(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Block source = user.find(this.userConfig.wallRange, b -> EarthMaterials.isEarthNotLava(user, b));
        if (source == null) {
            return false;
        }
        RaiseEarth raiseWall = new RaiseEarth(this.description());
        if (raiseWall.activate(user, source, 2, 3, 75L)) {
            this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(5000L + this.userConfig.wallDuration)).build();
            user.addCooldown(this.description(), this.userConfig.wallCooldown);
            raiseWall.pillars().map(Pillar::origin).map(b -> b.offset(Direction.UP, 2)).forEach(this.bases::add);
            this.wall = raiseWall;
            this.startTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (System.currentTimeMillis() > this.startTime + this.userConfig.wallDuration) {
            this.collapse();
        }
        Updatable.UpdateResult result = this.wall.update();
        return this.collapsing ? result : Updatable.UpdateResult.CONTINUE;
    }

    private void collapse() {
        if (this.collapsing) {
            return;
        }
        this.collapsing = true;
        Collapse collapseWall = new Collapse(this.description());
        if (collapseWall.activate(this.user, this.bases, 2)) {
            this.wall = collapseWall;
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long wallCooldown = 3000L;
        @Modifiable(value=Attribute.DURATION)
        private long wallDuration = 2000L;
        @Modifiable(value=Attribute.RANGE)
        private double wallRange = 4.5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "eartharmor", "wall");
        }
    }
}

