/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Pillar;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.FastMath;

public class Collapse
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Predicate<Block> predicate;
    private final MultiUpdatable<Pillar> pillars = MultiUpdatable.empty();
    private int height;

    public Collapse(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        boolean sneak;
        this.user = user;
        this.loadConfig();
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        Block origin = user.find(this.userConfig.selectRange, this.predicate);
        if (origin == null) {
            return false;
        }
        this.height = this.userConfig.maxHeight;
        boolean bl = sneak = method == Activation.SNEAK;
        if (sneak) {
            int offset = FastMath.ceil(this.userConfig.radius);
            int size = offset * 2 + 1;
            boolean[][] checked = new boolean[size][size];
            for (Block block : user.world().nearbyBlocks(origin.center(), this.userConfig.radius, this.predicate)) {
                Optional pillar;
                int dz;
                int dx;
                if (block.blockY() < origin.blockY() || checked[dx = offset + origin.blockX() - block.blockX()][dz = offset + origin.blockZ() - block.blockZ()] || !(pillar = block.world().findBottom(block, this.height, this.predicate).flatMap(this::createPillar)).isPresent()) continue;
                checked[dx][dz] = true;
                this.pillars.add((Pillar)pillar.get());
            }
        } else {
            origin.world().findBottom(origin, this.height, this.predicate).flatMap(this::createPillar).ifPresent(this.pillars::add);
        }
        if (!this.pillars.isEmpty()) {
            user.addCooldown(this.description(), this.userConfig.cooldown);
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    public boolean activate(User user, Collection<Block> sources, int height) {
        this.user = user;
        this.loadConfig();
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        this.height = height;
        for (Block block : sources) {
            block.world().findBottom(block, this.height, this.predicate).flatMap(this::createPillar).ifPresent(this.pillars::add);
        }
        if (!this.pillars.isEmpty()) {
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.pillars.update();
    }

    private Optional<Pillar> createPillar(Block block) {
        if (!this.predicate.test(block) || !TempBlock.isBendable(block)) {
            return Optional.empty();
        }
        return Pillar.builder(this.user, block).direction(Direction.DOWN).interval(75L).predicate(this.predicate).build(this.height);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 18.0;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 6.0;
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 500L;
        @Modifiable(value=Attribute.HEIGHT)
        private int maxHeight = 6;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "collapse");
        }
    }
}

