/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.common.basic.BlockShot;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.fire.Lightning;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class EarthBlast
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private Blast blast;

    public EarthBlast(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (method == Activation.SNEAK && EarthBlast.tryDestroy(user, this.userConfig)) {
            return false;
        }
        if (method == Activation.ATTACK) {
            List<EarthBlast> eblasts = user.game().abilityManager(user.worldKey()).userInstances(user, EarthBlast.class).toList();
            for (EarthBlast eblast : eblasts) {
                if (eblast.blast == null) {
                    eblast.launch();
                    continue;
                }
                eblast.blast.redirect();
            }
            return false;
        }
        Predicate<Block> predicate = b -> EarthMaterials.isEarthbendable(user, b) && !b.type().isLiquid();
        Block source = user.find(this.userConfig.selectRange, predicate);
        if (source == null) {
            return false;
        }
        BlockState fakeData = MaterialUtil.focusedType(source.type()).defaultState();
        List<EarthBlast> eblasts = user.game().abilityManager(user.worldKey()).userInstances(user, EarthBlast.class).filter(eb -> eb.blast == null).toList();
        for (EarthBlast eblast : eblasts) {
            State state = eblast.states.current();
            if (!(state instanceof SelectedSource.WithState)) continue;
            SelectedSource.WithState selectedSource = (SelectedSource.WithState)state;
            selectedSource.reselect(source, fakeData);
            return false;
        }
        this.states = new StateChain().addState(SelectedSource.create(user, source, this.userConfig.selectRange, fakeData)).start();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.blast == null ? this.states.update() : this.blast.update();
    }

    private void launch() {
        if (this.user.onCooldown(this.description())) {
            return;
        }
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            state.complete();
            Block source = this.states.chainStore().stream().findAny().orElse(null);
            if (source == null) {
                return;
            }
            if (EarthMaterials.isEarthbendable(this.user, source) && !source.type().isLiquid()) {
                this.blast = new Blast(source);
                SoundEffect.EARTH.play(source);
                this.removalPolicy = Policies.defaults();
                this.user.addCooldown(this.description(), this.userConfig.cooldown);
                TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(source);
            }
        }
    }

    private static boolean tryDestroy(User user, Config config) {
        List<EarthBlast> blasts = user.game().abilityManager(user.worldKey()).instances(EarthBlast.class).filter(eb -> eb.blast != null && !user.equals(eb.user) && eb.blast.blastType.canBend(user)).toList();
        Ray ray = user.ray(config.shatterRange + 2.0);
        double distSq = config.shatterRange * config.shatterRange;
        for (EarthBlast eb2 : blasts) {
            Vector3d center = eb2.blast.center();
            if (!(center.distanceSq(user.eyeLocation()) <= distSq) || !eb2.blast.collider().intersects(ray)) continue;
            Vector3d direction = (Vector3d)center.subtract(user.eyeLocation());
            double range = Math.min(1.0, direction.length());
            Block rayTraced = user.rayTrace(range).direction(direction).ignoreLiquids(false).blocks(user.world()).block();
            if (!user.world().blockAt(center).equals(rayTraced)) continue;
            user.game().abilityManager(user.worldKey()).destroyInstance(eb2);
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            SelectedSource selectedSource = (SelectedSource)state;
            selectedSource.onDestroy();
        }
        if (this.blast != null) {
            this.blast.clean();
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.blast == null ? List.of() : List.of(this.blast.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        if (collision.collidedAbility() instanceof Lightning && this.blast.electrify()) {
            collision.removeSelf(false);
            collision.removeOther(true);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 24.0;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 10.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.25;
        private double shatterRange = 14.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthblast");
        }
    }

    private class Blast
    extends BlockShot {
        private final BlastType blastType;
        private final double damage;
        private double electrified;

        public Blast(Block block) {
            super(EarthBlast.this.user, block, MaterialUtil.solidType(block.type()), EarthBlast.this.userConfig.range, 20);
            this.electrified = 1.0;
            this.blastType = EarthMaterials.isMetalBendable(block) ? BlastType.METAL : (EarthMaterials.isLavaBendable(block) ? BlastType.LAVA : BlastType.EARTH);
            this.damage = this.blastType.calculateDamage(EarthBlast.this.userConfig.damage);
        }

        @Override
        public void postRender(Vector3d location) {
            if (this.electrified > 1.0) {
                this.electrified = Math.max(1.0, this.electrified - 0.05);
                if (ThreadLocalRandom.current().nextInt(5) == 0) {
                    SoundEffect.LIGHTNING.play(EarthBlast.this.user.world(), location);
                }
                int particles = FastMath.ceil(24.0 * (this.electrified - 1.0));
                Particle.ELECTRIC_SPARK.builder(location).offset(0.5).count(particles).spawn(EarthBlast.this.user.world());
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(this.electrified * this.damage, EarthBlast.this.user, EarthBlast.this.description());
            entity.applyVelocity(EarthBlast.this, (Vector3d)this.direction.multiply(0.6));
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, 4, Ray.of(this.center(), this.direction));
            return true;
        }

        private boolean electrify() {
            if (this.blastType == BlastType.METAL && this.electrified <= 1.0) {
                this.electrified = 2.0;
                return true;
            }
            return false;
        }
    }

    private static enum BlastType {
        EARTH,
        METAL,
        LAVA;


        private boolean canBend(User user) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> user.hasPermission(FeaturePermissions.METAL);
                case 2 -> user.hasPermission(FeaturePermissions.LAVA);
            };
        }

        private double calculateDamage(double damage) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> damage;
                case 1 -> BendingProperties.instance().metalModifier(damage);
                case 2 -> BendingProperties.instance().magmaModifier(damage);
            };
        }
    }
}

