/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class EarthTunnel
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Predicate<Block> predicate;
    private Vector3d center;
    private double distance = 0.0;
    private int radius = 0;
    private int angle = 0;

    public EarthTunnel(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, EarthTunnel.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        Block block = user.find(this.userConfig.range, this.predicate);
        if (block == null) {
            return false;
        }
        this.center = block.center();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        int count = 0;
        while (++count <= this.userConfig.speed) {
            if (this.distance > this.userConfig.range) {
                return Updatable.UpdateResult.REMOVE;
            }
            Vector3d offset = VectorUtil.orthogonal(this.user.direction(), Math.toRadians(this.angle), this.radius);
            Block current = this.user.world().blockAt((Position)this.center.add(offset));
            if (!this.user.canBuild(current)) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.predicate.test(current)) {
                this.tryMineBlock(current);
            }
            if (this.angle >= 360) {
                int n;
                this.angle = 0;
                Block block = this.user.find(this.userConfig.range, this.predicate);
                if (block == null) {
                    return Updatable.UpdateResult.REMOVE;
                }
                this.center = block.center();
                ++this.radius;
                if (!((double)n > this.userConfig.radius)) continue;
                this.radius = 0;
                this.distance += 1.0;
                continue;
            }
            if (this.radius <= 0) {
                ++this.radius;
                continue;
            }
            this.angle += FastMath.ceil(22.5 / (double)this.radius);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void tryMineBlock(Block block) {
        Collection<Object> capturedDrops;
        if (this.userConfig.extractOres && !TempBlock.MANAGER.isTemp(block)) {
            capturedDrops = Platform.instance().factory().calculateOptimalOreDrops(block);
            if (!capturedDrops.isEmpty() && !this.userConfig.persistent) {
                BlockType type = block.type();
                BlockType newType = type.name().contains("nether") ? BlockType.NETHERRACK : (type.name().contains("deepslate") ? BlockType.DEEPSLATE : BlockType.STONE);
                block.setType(newType);
            }
        } else {
            capturedDrops = List.of();
        }
        if (this.userConfig.persistent) {
            block.setType(BlockType.AIR);
        } else {
            TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
        }
        Vector3d pos = block.center();
        capturedDrops.forEach(drop -> block.world().dropItem(pos, (ItemSnapshot)drop));
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 10.0;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 1.0;
        @Comment(value="How many blocks to excavate every tick")
        @Modifiable(value=Attribute.SPEED)
        private int speed = 2;
        private boolean extractOres = true;
        @Comment(value="Persistent earth tunnel will NOT revert blocks, use at your own risk")
        private boolean persistent = false;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthtunnel");
        }
    }
}

