/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Disk;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class LavaDisk
extends AbilityInstance {
    private static final String[] colors = new String[]{"#2F1600", "#5E2C00", "#8C4200", "#B05300", "#C45D00", "#F05A00", "#F0A000", "#F0BE00"};
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Vector3d location;
    private Vector3d direction;
    private Collider collider;
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private boolean launched = false;
    private double distance;
    private double distanceTravelled = 0.0;
    private double currentPower;
    private int rotationAngle = 0;

    public LavaDisk(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, LavaDisk.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        Predicate<Block> predicate = b -> EarthMaterials.isEarthbendable(user, b) && !EarthMaterials.isMetalBendable(b);
        Block source = user.find(this.userConfig.selectRange, predicate);
        if (source == null) {
            return false;
        }
        double r = 1.3;
        this.location = source.center();
        this.direction = user.direction();
        AABB aabb = AABB.of(Vector3d.of(-r, -0.3, -r), Vector3d.of(r, 0.3, r));
        this.collider = Disk.of(Sphere.of(r), OBB.of(aabb)).at(this.location);
        for (Block block : user.world().nearbyBlocks(aabb.at(this.location))) {
            if (MaterialUtil.isWater(block) || MaterialUtil.isWater(block.offset(Direction.UP))) {
                return false;
            }
            if (MaterialUtil.isLava(block)) continue;
            TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
        }
        this.distance = this.location.distance(user.eyeLocation());
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.range, () -> this.location)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.currentPower = this.userConfig.power;
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        double deltaDistance;
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.launched && this.distanceTravelled > this.userConfig.range) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.isLocationSafe() || this.currentPower <= 0.0) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.sneaking()) {
            this.launched = true;
        }
        this.distance = this.location.distance(this.user.eyeLocation());
        Vector3d targetLocation = (Vector3d)this.user.eyeLocation().add((Position)this.user.direction().multiply(this.launched ? this.userConfig.range + 5.0 : 3.0));
        if (this.location.distanceSq(targetLocation) > 0.25) {
            double speed = this.launched ? this.userConfig.speed : 0.66 * this.userConfig.speed;
            this.direction = ((Vector3d)targetLocation.subtract(this.location)).normalize();
            this.location = (Vector3d)this.location.add((Position)this.direction.multiply(speed));
            this.collider = this.collider.at(this.location);
            if (this.launched) {
                this.distanceTravelled += speed;
            }
        }
        double distanceModifier = (deltaDistance = this.distance - this.userConfig.selectRange) <= 0.0 ? 1.0 : (this.distance >= this.userConfig.range ? 0.0 : 1.0 - deltaDistance / this.userConfig.range);
        int deltaSpeed = Math.max(5, FastMath.ceil(15.0 * distanceModifier));
        this.rotationAngle += deltaSpeed % 2 == 0 ? ++deltaSpeed : deltaSpeed;
        if (this.rotationAngle >= 360) {
            this.rotationAngle = 0;
        }
        this.displayLavaDisk();
        double damage = Math.max(this.userConfig.minDamage, this.userConfig.maxDamage * distanceModifier);
        CollisionUtil.handle(this.user, this.collider, e -> this.damageEntity(e, damage));
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        BlockType.MAGMA_BLOCK.asParticle(this.location).count(16).offset(0.1).extra(0.01).spawn(this.user.world());
        Particle.LAVA.builder(this.location).count(2).offset(0.1).extra(0.01).spawn(this.user.world());
        Sound.BLOCK_STONE_BREAK.asEffect(1.0f, 1.5f).play(this.user.world(), this.location);
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.collider);
    }

    private boolean damageEntity(Entity entity, double damage) {
        if (this.affectedEntities.add(entity.uuid())) {
            Particle.LAVA.builder(entity.center()).count(4).offset(0.5).extra(0.1).spawn(this.user.world());
            BendingEffect.FIRE_TICK.apply(this.user, entity);
            entity.damage(damage, this.user, this.description());
            this.currentPower -= this.userConfig.powerDiminishPerEntity;
            return true;
        }
        return false;
    }

    private boolean damageBlock(Position position) {
        boolean tree;
        if (this.currentPower <= 0.0) {
            return false;
        }
        Block block = this.user.world().blockAt(position);
        FragileStructure.tryDamageStructure(block, 0, Ray.of(this.location, this.direction));
        if (!TempBlock.isBendable(block) || !this.user.canBuild(block)) {
            return false;
        }
        if (MaterialUtil.isLava(block)) {
            return true;
        }
        BlockType mat = block.type();
        boolean bl = tree = BlockTag.LEAVES.isTagged(mat) || BlockTag.LOGS_THAT_BURN.isTagged(mat);
        if (tree || EarthMaterials.isEarthOrSand(block)) {
            this.currentPower -= block.type().hardness();
            TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
            Vector3d center = block.center();
            Particle.LAVA.builder(center).offset(0.5).extra(0.05).spawn(this.user.world());
            if (ThreadLocalRandom.current().nextInt(4) == 0) {
                Sound.BLOCK_GRINDSTONE_USE.asEffect(0.3f, 0.3f).play(block);
            }
            return true;
        }
        return false;
    }

    private void displayLavaDisk() {
        this.damageBlock(this.location);
        float angle = this.user.yaw() + 90.0f;
        double cos = Math.cos(-angle);
        double sin = Math.sin(-angle);
        int offset = 0;
        int index = 0;
        float size = 0.8f;
        for (int i = 1; i <= 8; ++i) {
            for (int j = 0; j <= 288; j += 72) {
                int rotAngle = this.rotationAngle + j + offset;
                double length = 0.1 * (double)i;
                Vector3d temp = Vector3d.of(length * Math.cos(rotAngle), 0.0, length * Math.sin(rotAngle));
                Vector3d loc = (Vector3d)this.location.add(VectorUtil.rotateAroundAxisY(temp, cos, sin));
                ParticleBuilder.rgb((Position)loc, colors[index], size).spawn(this.user.world());
                if (!(length > 0.5)) continue;
                this.damageBlock(loc);
            }
            offset += 4;
            ++index;
            index = Math.min(colors.length - 1, index);
            size -= 0.05f;
        }
    }

    private boolean isLocationSafe() {
        Block block = this.user.world().blockAt(this.location);
        if (MaterialUtil.isWater(block)) {
            WorldUtil.playLavaExtinguishEffect(block);
            return false;
        }
        return MaterialUtil.isTransparent(block) || this.damageBlock(block);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 9000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double minDamage = 1.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double maxDamage = 4.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 18.0;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 6.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.75;
        @Modifiable(value=Attribute.STRENGTH)
        private double power = 20.0;
        private double powerDiminishPerEntity = 7.5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "lavadisk");
        }
    }
}

