/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.sequence;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Pillar;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public class EarthPillars
extends AbilityInstance {
    private static AbilityDescription pillarsDesc;
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<Pillar> pillars = MultiUpdatable.empty();
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private Predicate<Block> predicate;
    private double factor;

    public EarthPillars(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.factor = 1.0;
        if (method == Activation.FALL) {
            double dist = user.propertyValue(EntityProperties.FALL_DISTANCE);
            if (dist < this.userConfig.fallThreshold || user.sneaking()) {
                return false;
            }
            if (dist >= this.userConfig.maxFallThreshold) {
                this.factor = this.userConfig.maxScaleFactor;
            } else {
                double fd = this.userConfig.fallThreshold;
                double deltaFactor = (this.userConfig.maxScaleFactor - this.factor) * (dist - fd) / (this.userConfig.maxFallThreshold - fd);
                this.factor += deltaFactor;
            }
        }
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        Sphere collider = Sphere.of(user.location(), this.userConfig.radius * this.factor);
        CollisionUtil.handle(user, collider, this::createPillar, true);
        if (!this.pillars.isEmpty()) {
            user.addCooldown(this.description(), this.userConfig.cooldown);
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.pillars.update();
    }

    private boolean createPillar(Entity entity) {
        Block base = entity.block().offset(Direction.DOWN);
        boolean unique = this.pillars.stream().noneMatch(p -> p.origin().blockX() == base.blockX() && p.origin().blockZ() == base.blockZ());
        if (this.predicate.test(base)) {
            if (unique) {
                base.type().asParticle(entity.center()).count(8).offset(1.0, 0.1, 1.0).spawn(this.user.world());
                int length = FastMath.floor(3.0 * this.factor);
                Pillar.builder(this.user, base, x$0 -> new EarthPillar((Pillar.Builder<EarthPillar>)x$0)).predicate(this.predicate).build(length).ifPresent(this.pillars::add);
            }
            return true;
        }
        return false;
    }

    public static void onFall(User user) {
        if (user.hasAbilitySelected("catapult")) {
            if (pillarsDesc == null) {
                pillarsDesc = Objects.requireNonNull(Registries.ABILITIES.fromString("EarthPillars"));
            }
            user.game().activationController().activateAbility(user, Activation.FALL, pillarsDesc);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 10.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.8;
        private double maxScaleFactor = 1.5;
        private double fallThreshold = 12.0;
        private double maxFallThreshold = 60.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "sequences", "earthpillars");
        }
    }

    private final class EarthPillar
    extends Pillar {
        private EarthPillar(Pillar.Builder<EarthPillar> builder) {
            super(builder);
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (!entity.uuid().equals(EarthPillars.this.user.uuid()) && EarthPillars.this.affectedEntities.add(entity.uuid())) {
                entity.damage(EarthPillars.this.userConfig.damage * EarthPillars.this.factor, EarthPillars.this.user, EarthPillars.this.description());
            }
            entity.applyVelocity(EarthPillars.this, (Vector3d)Vector3d.PLUS_J.multiply(EarthPillars.this.userConfig.knockup * EarthPillars.this.factor));
            return true;
        }
    }
}

