/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;

public final class Boulder {
    private final Map<Vector3i, BlockState> data;
    private final AABB bounds;
    private final AABB preciseBounds;
    private final World world;
    private User user;
    private Vector3d center;
    private final int size;
    private final long expireTime;

    public Boulder(User user, Block centerBlock, int size, long duration) {
        this.user = user;
        this.world = user.world();
        this.size = size;
        this.expireTime = System.currentTimeMillis() + duration;
        this.data = new HashMap<Vector3i, BlockState>();
        this.center = centerBlock.center();
        double hr = (double)size / 2.0;
        this.preciseBounds = AABB.of(Vector3d.of(-hr, -hr, -hr), Vector3d.of(hr, hr, hr));
        this.bounds = this.preciseBounds.grow(Vector3d.ONE);
        this.initData(centerBlock);
    }

    private void initData(Block centerBlock) {
        int half = (this.size - 1) / 2;
        Block temp = centerBlock.offset(Direction.DOWN, half);
        ArrayList<BlockType> earthData = new ArrayList<BlockType>();
        for (int dy = -half; dy <= half; ++dy) {
            for (int dz = -half; dz <= half; ++dz) {
                for (int dx = -half; dx <= half; ++dx) {
                    Block block = temp.offset(dx, dy, dz);
                    if (!this.user.canBuild(block)) continue;
                    BlockState bd = null;
                    if (EarthMaterials.isEarthNotLava(this.user, block)) {
                        bd = MaterialUtil.solidType(block.type()).defaultState();
                        earthData.add(bd.type());
                    } else if (MaterialUtil.isTransparent(block)) {
                        bd = earthData.isEmpty() ? BlockType.DIRT.defaultState() : ((BlockType)earthData.get(ThreadLocalRandom.current().nextInt(earthData.size()))).defaultState();
                    }
                    if (bd == null || (Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) % 2 != 0) continue;
                    this.data.put(Vector3i.of(dx, dy, dz), bd);
                }
            }
        }
    }

    public User user() {
        return this.user;
    }

    public void user(User user) {
        this.user = user;
    }

    public World world() {
        return this.world;
    }

    public AABB bounds() {
        return this.bounds;
    }

    public AABB preciseBounds() {
        return this.preciseBounds;
    }

    public int size() {
        return this.size;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int dataSize() {
        return this.data.size();
    }

    public boolean isValidBlock(Block block) {
        if (!MaterialUtil.isTransparent(block) || !TempBlock.isBendable(block)) {
            return false;
        }
        return this.user.canBuild(block);
    }

    public void updateData() {
        this.data.entrySet().removeIf(entry -> {
            BlockType type = this.world.getBlockType((Position)this.center.add((Position)entry.getKey()));
            return type != ((BlockState)entry.getValue()).type();
        });
    }

    public void updateData(BiFunction<Vector3i, BlockState, BlockState> mapper) {
        this.data.replaceAll(mapper);
    }

    public void clearData() {
        this.data.clear();
    }

    public boolean blendSmash(Vector3d direction) {
        int originalSize = this.data.size();
        ArrayList<Block> removed = new ArrayList<Block>();
        Iterator<Vector3i> iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            Block block = this.world.blockAt((Position)this.center.add(iterator.next()));
            if (this.isValidBlock(block)) continue;
            removed.add(block);
            iterator.remove();
        }
        FragileStructure.tryDamageStructure(removed, 4 * removed.size(), Ray.of(this.center, direction));
        return !this.data.isEmpty() && originalSize - this.data.size() <= this.size;
    }

    public boolean isValidCenter(Block check) {
        Vector3d temp = check.center();
        return this.data.keySet().stream().map(v -> this.world.blockAt((Position)temp.add((Position)v))).allMatch(this::isValidBlock);
    }

    public Vector3d center() {
        return this.center;
    }

    public void center(Position position) {
        this.center = position.center();
    }

    public Collider collider() {
        return this.bounds.at(this.center);
    }

    public Map<Block, BlockState> data() {
        return this.data.entrySet().stream().collect(Collectors.toMap(e -> this.world.blockAt((Position)this.center.add((Position)e.getKey())), Map.Entry::getValue));
    }
}

