/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Explosive;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.BendingExplosion;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.AbilityInitializer;
import me.moros.bending.common.ability.fire.FireShield;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class FireBlast
extends AbilityInstance
implements Explosive {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private FireStream stream;
    private Collider ignoreCollider;
    private boolean charging;
    private boolean exploded = false;
    private double factor = 1.0;
    private long startTime;

    public FireBlast(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.startTime = System.currentTimeMillis();
        this.charging = true;
        if (user.world().blockAt(user.mainHandSide()).type().isLiquid()) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        for (FireBlast blast : user.game().abilityManager(user.worldKey()).userInstances(user, FireBlast.class).toList()) {
            if (!blast.charging) continue;
            blast.launch();
            return false;
        }
        if (method == Activation.ATTACK) {
            this.launch();
        }
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.exploded || this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.charging) {
            if (!this.description().equals(this.user.selectedAbility())) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.user.sneaking() && System.currentTimeMillis() >= this.startTime + this.userConfig.maxChargeTime) {
                ParticleBuilder.fire(this.user, this.user.mainHandSide()).spawn(this.user.world());
            } else if (!this.user.sneaking()) {
                this.launch();
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.stream.update();
    }

    private void launch() {
        long deltaTime = System.currentTimeMillis() - this.startTime;
        this.factor = 1.0;
        long cooldown = this.userConfig.cooldown;
        if (deltaTime >= this.userConfig.maxChargeTime) {
            this.factor = this.userConfig.chargeFactor;
            cooldown = this.userConfig.chargedCooldown;
        } else if ((double)deltaTime > 0.3 * (double)this.userConfig.maxChargeTime) {
            double deltaFactor = (this.userConfig.chargeFactor - this.factor) * (double)deltaTime / (double)this.userConfig.maxChargeTime;
            this.factor += deltaFactor;
        }
        this.charging = false;
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), cooldown);
        Vector3d origin = this.user.mainHandSide();
        Vector3d lookingDir = (Vector3d)this.user.direction().multiply(this.userConfig.range * this.factor);
        this.stream = new FireStream(Ray.of(origin, lookingDir));
    }

    @Override
    public Collection<Collider> colliders() {
        return this.stream == null ? List.of() : List.of(this.stream.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        boolean fullyCharged;
        Ability collidedAbility = collision.collidedAbility();
        boolean bl = fullyCharged = Math.abs(this.factor - this.userConfig.chargeFactor) < 0.001;
        if (fullyCharged && collision.removeSelf()) {
            if (AbilityInitializer.layer2.containsValue(collidedAbility.description().key())) {
                collision.removeOther(true);
            } else {
                collision.removeSelf(false);
            }
        }
        if (fullyCharged && collidedAbility instanceof FireShield) {
            FireShield fireShield = (FireShield)collidedAbility;
            collision.removeOther(true);
            if (fireShield.isSphere()) {
                this.ignoreCollider = collision.colliderOther();
                this.explode();
            }
        } else if (collidedAbility instanceof FireBlast) {
            FireBlast other = (FireBlast)collidedAbility;
            double collidedFactor = other.factor;
            if (fullyCharged && Math.abs(collidedFactor - other.userConfig.chargeFactor) < 0.001) {
                Vector3d first = collision.colliderSelf().position();
                Vector3d second = collision.colliderOther().position();
                Vector3d center = (Vector3d)((Vector3d)first.add(second)).multiply(0.5);
                double radius = this.userConfig.explosionRadius + other.userConfig.explosionRadius;
                double dmg = this.userConfig.damage + other.userConfig.damage;
                this.createExplosion(center, radius, dmg * (this.factor + other.factor - 1.0));
                other.exploded = true;
            } else if (this.factor > collidedFactor + 0.1) {
                collision.removeSelf(false);
            }
        } else if (fullyCharged && collidedAbility instanceof Explosive) {
            this.explode();
        }
    }

    @Override
    public void explode() {
        this.createExplosion(this.stream.collider().position(), this.userConfig.explosionRadius, this.userConfig.damage * this.factor);
    }

    private void createExplosion(Vector3d center, double size, double damage) {
        if (this.exploded || this.factor < this.userConfig.chargeFactor) {
            return;
        }
        this.exploded = true;
        BendingExplosion.builder().size(size).damage(damage).fireTicks(this.userConfig.fireTicks).ignoreInsideCollider(this.ignoreCollider).sound(5.0f, 1.0f).buildAndExplode(this, center);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1500L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 25;
        @Modifiable(value=Attribute.RANGE)
        private double range = 18.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;
        @Modifiable(value=Attribute.RADIUS)
        private double igniteRadius = 1.5;
        @Modifiable(value=Attribute.RADIUS)
        private double explosionRadius = 2.5;
        @Comment(value="How much the damage, radius, range and speed are multiplied by at full charge")
        @Modifiable(value=Attribute.STRENGTH)
        private double chargeFactor = 1.5;
        @Comment(value="How many milliseconds it takes to fully charge")
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long maxChargeTime = 1500L;
        @Modifiable(value=Attribute.COOLDOWN)
        private long chargedCooldown = 500L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "fireblast");
        }
    }

    private class FireStream
    extends ParticleStream {
        private final double offset;
        private final double particleSpeed;
        private final int amount;
        private final boolean explosive;
        private int ticks;

        public FireStream(Ray ray) {
            super(FireBlast.this.user, ray, FireBlast.this.userConfig.speed * FireBlast.this.factor, 0.8 + 0.5 * (FireBlast.this.factor - 1.0));
            this.ticks = 3;
            this.canCollide = BlockProperties::isLiquid;
            this.offset = 0.25 + (FireBlast.this.factor - 1.0);
            this.particleSpeed = 0.02 * FireBlast.this.factor;
            this.amount = FastMath.ceil(6.0 * Math.pow(FireBlast.this.factor, 4.0));
            this.singleCollision = this.explosive = Math.abs(FireBlast.this.factor - FireBlast.this.userConfig.chargeFactor) < 0.001;
        }

        @Override
        public void render(Vector3d location) {
            ParticleBuilder.fire(FireBlast.this.user, location).count(this.amount).offset(this.offset).extra(this.particleSpeed).spawn(FireBlast.this.user.world());
            TempLight.builder(++this.ticks).build(FireBlast.this.user.world().blockAt(location));
        }

        @Override
        public void postRender(Vector3d location) {
            if (this.explosive || ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.FIRE.play(FireBlast.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (this.explosive) {
                FireBlast.this.explode();
                return true;
            }
            BendingEffect.FIRE_TICK.apply(FireBlast.this.user, entity, FireBlast.this.userConfig.fireTicks);
            entity.damage(FireBlast.this.userConfig.damage * FireBlast.this.factor, FireBlast.this.user, FireBlast.this.description());
            entity.applyVelocity(FireBlast.this, (Vector3d)this.ray.direction().normalize().multiply(0.5));
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            Vector3d reverse = this.ray.direction().negate();
            WorldUtil.tryLightBlock(block);
            Vector3d standing = FireBlast.this.user.location().add(0.0, 0.5, 0.0);
            for (Block b : FireBlast.this.user.world().nearbyBlocks(this.collider().position(), FireBlast.this.userConfig.igniteRadius * FireBlast.this.factor)) {
                if (standing.distanceSq(b.center()) < 4.0 || !FireBlast.this.user.canBuild(b) || FireBlast.this.user.rayTrace(b.center(), reverse).range(FireBlast.this.userConfig.igniteRadius + 2.0).blocks(FireBlast.this.user.world()).hit() || !MaterialUtil.isIgnitable(b)) continue;
                TempBlock.fire().duration(BendingProperties.instance().fireRevertTime(1000L)).ability(FireBlast.this).build(b);
            }
            FragileStructure.tryDamageStructure(block, FastMath.round(4.0 * FireBlast.this.factor), Ray.of(this.collider().position(), this.ray.direction()));
            FireBlast.this.explode();
            return true;
        }
    }
}

