/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import net.kyori.adventure.util.TriState;

public class FireJet
extends AbilityInstance {
    private static final SoundEffect LOUD_EXPLOSION = SoundEffect.EXPLOSION.with(10.0f, 0.0f);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private boolean jetBlast;
    private TriState wasGliding = TriState.NOT_SET;
    private long duration;
    private long startTime;
    private int ticks = 3;

    public FireJet(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).destroyUserInstances(user, FireJet.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        Block block = user.block();
        boolean ignitable = MaterialUtil.isIgnitable(block);
        if (!ignitable && !MaterialUtil.isAir(block)) {
            return false;
        }
        if (ignitable) {
            this.igniteBlock(block);
        }
        if (user.sneaking()) {
            this.jetBlast = true;
            this.duration = this.userConfig.jetBlastDuration;
            this.jetBlastAnimation();
        } else {
            this.jetBlast = false;
            this.duration = this.userConfig.duration;
        }
        this.wasGliding = user.checkProperty(EntityProperties.GLIDING);
        user.setProperty(EntityProperties.GLIDING, true);
        this.removalPolicy = Policies.builder().add(Policies.PARTIALLY_UNDER_WATER).add(Policies.PARTIALLY_UNDER_LAVA).add(ExpireRemovalPolicy.of(this.duration)).build();
        this.startTime = System.currentTimeMillis();
        return true;
    }

    private void igniteBlock(Block block) {
        TempBlock.fire().duration(BendingProperties.instance().fireRevertTime()).ability(this).build(block);
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    private void jetBlastAnimation() {
        Vector3d center = this.user.location().add(0.0, 0.2, 0.0);
        VectorUtil.circle(Vector3d.PLUS_I, Vector3d.PLUS_J, 36).forEach(v -> ParticleBuilder.fire(this.user, center.add((Position)v.multiply(0.5))).count(0).offset((Position)v).extra(0.09).spawn(this.user.world()));
        LOUD_EXPLOSION.play(this.user.world(), this.user.location());
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        double halfSpeed = 0.5 * (this.jetBlast ? this.userConfig.jetBlastSpeed : this.userConfig.speed);
        double timeFactor = (double)(System.currentTimeMillis() - this.startTime) / (double)this.duration;
        double speed = halfSpeed + halfSpeed * Math.sin(Math.PI * timeFactor);
        this.user.applyVelocity(this, (Vector3d)this.user.direction().multiply(speed));
        this.user.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
        Vector3d target = (Vector3d)this.user.location().add(this.user.velocity().negate());
        int amount = this.jetBlast ? 16 : 10;
        double offset = this.jetBlast ? 0.7 : 0.4;
        double particleSpeed = 0.05 * Math.min(1.0, speed);
        for (int i = 0; i < amount; ++i) {
            Vector3d center = VectorUtil.gaussianOffset(this.user.location(), offset);
            Vector3d v = (Vector3d)target.subtract(center);
            ParticleBuilder.fire(this.user, center).count(0).offset(v).extra(particleSpeed).spawn(this.user.world());
        }
        TempLight.builder(++this.ticks).build(this.user.block());
        if (ThreadLocalRandom.current().nextBoolean()) {
            SoundEffect.FIRE.play(this.user.world(), this.user.location());
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.jetBlast ? this.userConfig.jetBlastCooldown : this.userConfig.cooldown);
        this.user.setProperty(EntityProperties.GLIDING, this.wasGliding);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.85;
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 7000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 2000L;
        @Modifiable(value=Attribute.SPEED)
        private double jetBlastSpeed = 1.5;
        @Modifiable(value=Attribute.COOLDOWN)
        private long jetBlastCooldown = 10000L;
        @Modifiable(value=Attribute.DURATION)
        private long jetBlastDuration = 2000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "firejet");
        }
    }
}

