/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Disk;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;
import net.kyori.adventure.key.Key;

public class FireShield
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private Shield shield;
    private ThreadLocalRandom rand;
    private boolean sphere = false;

    public FireShield(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, FireShield.class)) {
            return false;
        }
        if (Policies.PARTIALLY_UNDER_WATER.test(user, this.description()) || Policies.PARTIALLY_UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.rand = ThreadLocalRandom.current();
        if (method == Activation.SNEAK) {
            this.sphere = true;
            this.shield = new SphereShield();
            this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(ExpireRemovalPolicy.of(this.userConfig.shieldDuration)).add(Policies.NOT_SNEAKING).add(Policies.PARTIALLY_UNDER_WATER).add(Policies.PARTIALLY_UNDER_LAVA).build();
        } else {
            this.shield = new DiskShield();
            this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(ExpireRemovalPolicy.of(this.userConfig.diskDuration)).add(Policies.PARTIALLY_UNDER_WATER).add(Policies.PARTIALLY_UNDER_LAVA).build();
        }
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.shield.render();
        CollisionUtil.handle(this.user, this.shield.collider(), this::onEntityHit, false);
        this.shield.update();
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean onEntityHit(Entity entity) {
        if (this.sphere && entity.isProjectile()) {
            if (entity.type() != EntityType.TRIDENT) {
                entity.remove();
            }
            return true;
        }
        BendingEffect.FIRE_TICK.apply(this.user, entity);
        if (this.affectedEntities.add(entity.uuid())) {
            entity.damage(this.userConfig.damage, this.user, this.description());
        }
        return false;
    }

    public boolean isSphere() {
        return this.sphere;
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.sphere ? this.userConfig.shieldCooldown : this.userConfig.diskCooldown);
        this.shield.onDestroy();
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.shield.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        if (!this.sphere) {
            List<Key> ignore = List.of(KeyUtil.simple("earthblast"), KeyUtil.simple("watermanipulation"));
            if (collision.removeOther() && ignore.contains(collision.collidedAbility().description().key())) {
                collision.removeOther(false);
            }
        }
    }

    public static double shieldFromExplosion(User user, Vector3d source, double damage) {
        double r;
        FireShield shield = user.game().abilityManager(user.worldKey()).userInstances(user, FireShield.class).filter(FireShield::isSphere).findAny().orElse(null);
        if (shield == null) {
            return damage;
        }
        double distSq = source.distanceSq(user.center());
        if (distSq >= (r = shield.userConfig.shieldRadius) * r) {
            return 0.0;
        }
        return 0.25 * damage;
    }

    private final class SphereShield
    implements Shield {
        private Sphere sphere;
        private TempLight light;
        private int currentPoint = 0;

        private SphereShield() {
            this.update();
        }

        private Vector3d center() {
            return FireShield.this.user.center();
        }

        @Override
        public Collider collider() {
            return this.sphere;
        }

        @Override
        public void update() {
            this.sphere = Sphere.of(this.center(), FireShield.this.userConfig.shieldRadius);
        }

        @Override
        public void render() {
            Vector3d center = this.center();
            double radius = FireShield.this.userConfig.shieldRadius;
            ++this.currentPoint;
            double spacing = radius / 16.0;
            for (int i = 1; i < 32; ++i) {
                double y = (double)i * spacing - radius;
                double factor = 1.0 - y * y / (radius * radius);
                if (factor <= 0.2) continue;
                double x = radius * factor * Math.cos(i * this.currentPoint);
                double z = radius * factor * Math.sin(i * this.currentPoint);
                Vector3d spawnLoc = center.add(x, y, z);
                ParticleBuilder.fire(FireShield.this.user, spawnLoc).offset(0.1).extra(0.005).spawn(FireShield.this.user.world());
                if (FireShield.this.rand.nextInt(12) != 0) continue;
                SoundEffect.FIRE.play(FireShield.this.user.world(), spawnLoc);
            }
            Block block = FireShield.this.user.world().blockAt(center);
            this.createLight(block);
        }

        private void createLight(Block block) {
            if (this.light != null && !this.light.block().equals(block)) {
                this.light.unlock();
            }
            this.light = TempLight.builder(5 + this.currentPoint).rate(1).duration(FireShield.this.userConfig.shieldDuration + 750L).build(block).map(TempLight::lock).orElse(null);
        }

        @Override
        public void onDestroy() {
            if (this.light != null) {
                this.light.unlock();
                this.light = null;
            }
        }
    }

    private static interface Shield {
        public void update();

        public void render();

        public Collider collider();

        public void onDestroy();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 0.5;
        @Modifiable(value=Attribute.COOLDOWN)
        private long diskCooldown = 1000L;
        @Modifiable(value=Attribute.DURATION)
        private long diskDuration = 1000L;
        @Modifiable(value=Attribute.RADIUS)
        private double diskRadius = 2.0;
        @Modifiable(value=Attribute.RANGE)
        private double diskRange = 1.5;
        @Modifiable(value=Attribute.COOLDOWN)
        private long shieldCooldown = 2000L;
        @Modifiable(value=Attribute.DURATION)
        private long shieldDuration = 10000L;
        @Modifiable(value=Attribute.RADIUS)
        private double shieldRadius = 3.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "fireshield");
        }
    }

    private final class DiskShield
    implements Shield {
        private Disk disk;
        private Vector3d location;
        private TempLight light;
        private long nextRenderTime = 0L;
        private int ticks = 6;

        private DiskShield() {
            this.update();
        }

        @Override
        public void update() {
            this.location = (Vector3d)FireShield.this.user.eyeLocation().add((Position)FireShield.this.user.direction().multiply(FireShield.this.userConfig.diskRange));
            double r = FireShield.this.userConfig.diskRadius;
            AABB aabb = AABB.of(Vector3d.of(-r, -r, -1.0), Vector3d.of(r, r, 1.0));
            Vector3d right = FireShield.this.user.rightSide();
            Rotation rotation = Rotation.from(Vector3d.PLUS_J, Math.toRadians(FireShield.this.user.yaw()));
            rotation = rotation.applyTo(Rotation.from(right, Math.toRadians(FireShield.this.user.pitch())));
            this.disk = Disk.of(Sphere.of(FireShield.this.userConfig.diskRadius), OBB.of(aabb, rotation)).at(this.location);
        }

        @Override
        public void render() {
            long time = System.currentTimeMillis();
            if (time < this.nextRenderTime) {
                return;
            }
            this.nextRenderTime = time + 200L;
            Rotation rotation = Rotation.from(FireShield.this.user.direction(), Math.toRadians(20.0));
            double[] array = Vector3d.PLUS_J.cross(FireShield.this.user.direction()).normalize().toArray();
            for (int i = 0; i < 18; ++i) {
                for (double j = 0.2; j <= 1.0; j += 0.2) {
                    Vector3d spawnLoc = (Vector3d)this.location.add((Position)Vector3d.from(array).multiply(j * FireShield.this.userConfig.diskRadius));
                    ParticleBuilder.fire(FireShield.this.user, spawnLoc).offset(0.15).extra(0.01).spawn(FireShield.this.user.world());
                    if (FireShield.this.rand.nextInt(20) != 0) continue;
                    SoundEffect.FIRE.play(FireShield.this.user.world(), spawnLoc);
                }
                rotation.applyTo(array, array);
            }
            this.createLight(FireShield.this.user.world().blockAt(this.location));
        }

        private void createLight(Block block) {
            if (this.light != null && !this.light.block().equals(block)) {
                this.light.unlock();
            }
            this.light = TempLight.builder(++this.ticks).rate(1).duration(FireShield.this.userConfig.diskDuration + 750L).build(block).map(TempLight::lock).orElse(null);
        }

        @Override
        public Collider collider() {
            return this.disk;
        }

        @Override
        public void onDestroy() {
            if (this.light != null) {
                this.light.unlock();
                this.light = null;
            }
        }
    }
}

