/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire.sequence;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class FireSpin
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private final MultiUpdatable<FireStream> streams = MultiUpdatable.empty();

    public FireSpin(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Vector3d origin = (Vector3d)user.location().add(Vector3d.PLUS_J);
        VectorUtil.circle(Vector3d.PLUS_I, Vector3d.PLUS_J, 40).forEach(v -> this.streams.add(new FireStream(Ray.of(origin, (Vector3d)v.multiply(this.userConfig.range)))));
        this.removalPolicy = Policies.defaults();
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.streams.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 6.0;
        @Comment(value="How many blocks the streams advance with each tick")
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.5;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.8;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "sequences", "firespin");
        }
    }

    private class FireStream
    extends ParticleStream {
        private int ticks;

        public FireStream(Ray ray) {
            super(FireSpin.this.user, ray, FireSpin.this.userConfig.speed / 2.0, 0.5);
            this.ticks = 3;
            this.canCollide = BlockProperties::isLiquid;
            this.steps = 2;
        }

        @Override
        public void render(Vector3d location) {
            ParticleBuilder.fire(FireSpin.this.user, location).extra(0.01).spawn(FireSpin.this.user.world());
            TempLight.builder(++this.ticks).build(FireSpin.this.user.world().blockAt(location));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(12) == 0) {
                SoundEffect.FIRE.play(FireSpin.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (FireSpin.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FIRE_TICK.apply(FireSpin.this.user, entity);
                entity.damage(FireSpin.this.userConfig.damage, FireSpin.this.user, FireSpin.this.description());
                entity.applyVelocity(FireSpin.this, (Vector3d)this.ray.direction().normalize().multiply(FireSpin.this.userConfig.knockback));
            }
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, 3, Ray.of(this.collider().position(), this.ray.direction()));
            return true;
        }
    }
}

