/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.InventoryUtil;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.math.FastMath;
import me.moros.math.Position;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;

public class HealingWaters
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("healingwaters-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private boolean healed = false;
    private long nextTime;

    public HealingWaters(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, HealingWaters.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.nextTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        long time = System.currentTimeMillis();
        if (time >= this.nextTime) {
            this.nextTime = time + 250L;
            if (!this.tryHeal()) {
                return Updatable.UpdateResult.REMOVE;
            }
        }
        ParticleBuilder.rgb((Position)this.user.mainHandSide(), "#00FFFF").spawn(this.user.world());
        return Updatable.UpdateResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryHeal() {
        void var1_7;
        Mode mode = this.user.store().get(KEY).orElse(Mode.SELF);
        if (mode == Mode.OTHERS) {
            LivingEntity living;
            Entity entity = this.user.rayTrace(this.userConfig.range + 1.0).cast(this.user.world()).entity();
            if (!(entity instanceof LivingEntity)) return false;
            LivingEntity livingEntity = living = (LivingEntity)entity;
        } else {
            User user = this.user;
        }
        if (!var1_7.inWater() && !InventoryUtil.hasFullBottle(this.user)) {
            return false;
        }
        EntityUtil.removeNegativeEffects((LivingEntity)var1_7);
        if (!(var1_7.propertyValue(EntityProperties.HEALTH).floatValue() < var1_7.propertyValue(EntityProperties.MAX_HEALTH).floatValue())) return true;
        ParticleBuilder.rgb((Position)var1_7.center(), "#00FFFF").count(6).offset(0.35).spawn(this.user.world());
        int ticks = FastMath.floor((double)this.userConfig.duration / 50.0);
        if (!EntityUtil.tryAddPotion((Entity)var1_7, PotionEffect.REGENERATION, ticks, this.userConfig.power - 1)) return true;
        this.healed = true;
        return true;
    }

    public static void switchMode(User user) {
        if (user.hasAbilitySelected("healingwaters") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.SELF);
            user.sendActionBar((Component)Component.text((String)("Healing: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
        }
    }

    @Override
    public void onDestroy() {
        if (this.healed) {
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 3000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 3000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 5.0;
        @Modifiable(value=Attribute.STRENGTH)
        private int power = 2;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "healingwaters");
        }
    }

    private static enum Mode {
        SELF,
        OTHERS;

    }
}

