/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.TravellingSource;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.ability.water.sequence.WaterGimbal;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WaterRing
extends AbilityInstance {
    private static final double RING_RADIUS = 2.8;
    private static AbilityDescription ringDesc;
    private static AbilityDescription waveDesc;
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Position lastPosition;
    private StateChain states;
    private final List<Block> ring = new ArrayList<Block>(24);
    private final Collection<IceShard> shards = new ArrayList<IceShard>(16);
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private boolean ready = false;
    private boolean completed = false;
    private boolean destroyed = false;
    private double radius = 2.8;
    private int index = 0;
    private int sources = 0;
    private long nextShardTime = 0L;
    private long ringNextShrinkTime = 0L;
    private long sneakStartTime = 0L;

    public WaterRing(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, WaterGimbal.class)) {
            return false;
        }
        Optional<WaterRing> ring = user.game().abilityManager(user.worldKey()).firstInstance(user, WaterRing.class);
        if (ring.isPresent()) {
            if (method == Activation.ATTACK && user.hasAbilitySelected("waterring")) {
                if (user.sneaking()) {
                    user.game().abilityManager(user.worldKey()).destroyInstance(ring.get());
                } else {
                    ring.get().launchShard();
                }
            }
            return false;
        }
        this.user = user;
        this.loadConfig();
        Block source = user.find(this.userConfig.selectRange, WaterMaterials::isFullWaterSource);
        if (source == null) {
            return false;
        }
        ArrayList<Block> list = new ArrayList<Block>();
        list.add(source);
        this.states = new StateChain(list).addState(new TravellingSource(user, BlockType.WATER.defaultState(), 2.3, this.userConfig.selectRange + 5.0)).start();
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        if (waveDesc == null) {
            waveDesc = Objects.requireNonNull(Registries.ABILITIES.fromString("WaterWave"));
        }
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    public List<Block> complete() {
        if (!this.ready || this.completed) {
            return List.of();
        }
        this.completed = true;
        this.sources = 0;
        int i = this.getDirectionIndex();
        if (i == 0) {
            return this.ring;
        }
        return Stream.concat(this.ring.subList(i, this.ring.size()).stream(), this.ring.subList(0, i).stream()).toList();
    }

    private Block getClosestRingBlock() {
        Vector3d dir = (Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize().multiply(this.radius);
        Block target = this.user.world().blockAt((Position)this.user.eyeBlock().center().add(dir));
        Block result = this.ring.getFirst();
        Vector3d targetVector = target.toVector3d();
        double minDistance = Double.MAX_VALUE;
        for (Block block : this.ring) {
            if (target.equals(block)) {
                return target;
            }
            double d = block.distanceSq(targetVector);
            if (!(d < minDistance)) continue;
            minDistance = d;
            result = block;
        }
        return result;
    }

    private int getDirectionIndex() {
        Vector3d dir = (Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize().multiply(this.radius);
        Block target = this.user.world().blockAt((Position)this.user.eyeBlock().center().add(dir));
        return Math.max(0, this.ring.indexOf(target));
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.completed || this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.ready) {
            if (this.states.update() == Updatable.UpdateResult.REMOVE) {
                if (this.states.completed() && !this.states.chainStore().isEmpty()) {
                    this.ring.addAll(WorldUtil.createBlockRing(this.user.eyeBlock(), this.radius));
                    this.sources = this.ring.size();
                    this.ready = true;
                } else {
                    return Updatable.UpdateResult.REMOVE;
                }
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        this.cleanAll();
        if (this.sources <= 0 || !this.user.canBuild()) {
            return Updatable.UpdateResult.REMOVE;
        }
        Vector3i newPosition = this.user.location().toVector3i();
        if (!newPosition.equals(this.lastPosition)) {
            this.ring.clear();
            this.ring.addAll(WorldUtil.createBlockRing(this.user.eyeBlock(), this.radius));
            Collections.rotate(this.ring, this.index);
            this.lastPosition = newPosition;
        }
        if (this.user.sneaking() && !this.user.hasAbilitySelected("octopusform")) {
            long time = System.currentTimeMillis();
            if (this.sneakStartTime == 0L) {
                this.sneakStartTime = time;
                this.ringNextShrinkTime = time + 250L;
            } else {
                if (this.ringNextShrinkTime > time && this.radius > 1.3) {
                    this.radius(this.radius - 0.3);
                    this.ringNextShrinkTime = time + 250L;
                }
                if (time > this.sneakStartTime + this.userConfig.waveChargeTime && !this.user.onCooldown(waveDesc)) {
                    if (!this.complete().isEmpty()) {
                        this.user.game().activationController().activateAbility(this.user, Activation.SNEAK, waveDesc);
                    }
                    return Updatable.UpdateResult.REMOVE;
                }
            }
        } else {
            this.sneakStartTime = 0L;
            if (this.radius < 2.8) {
                this.radius(Math.min(this.radius + 0.3, 2.8));
            }
        }
        if (this.ring.stream().noneMatch(this.user::canBuild)) {
            return Updatable.UpdateResult.REMOVE;
        }
        Collections.rotate(this.ring, 1);
        ++this.index;
        this.index %= this.ring.size();
        int length = Math.min(this.ring.size(), FastMath.ceil((double)this.sources * 0.8));
        for (int i = 0; i < length; ++i) {
            Block block = this.ring.get(i);
            if (MaterialUtil.isWater(block) && !TempBlock.MANAGER.isTemp(block)) {
                ParticleBuilder.bubble(block).spawn(this.user.world());
                continue;
            }
            if (!MaterialUtil.isTransparent(block)) continue;
            TempBlock.water().duration(250L).build(block);
        }
        if (this.userConfig.affectEntities) {
            CollisionUtil.handle(this.user, Sphere.of(this.user.eyeLocation(), this.radius + 2.0), this::checkCollisions, false);
        }
        this.shards.removeIf(shard -> shard.update() == Updatable.UpdateResult.REMOVE);
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean checkCollisions(Entity entity) {
        if (!this.affectedEntities.contains(entity.uuid())) {
            for (Block block : this.ring) {
                AABB blockBounds = AABB.BLOCK_BOUNDS.at(block);
                AABB entityBounds = entity.bounds();
                if (!MaterialUtil.isWater(block) || blockBounds.intersects(entityBounds)) continue;
                this.affectedEntities.add(entity.uuid());
                entity.damage(this.userConfig.damage, this.user, this.description());
                Vector3d velocity = ((Vector3d)((Vector3d)entity.location().subtract(this.user.eyeLocation())).withY(0.0)).normalize();
                entity.applyVelocity(this, (Vector3d)velocity.multiply(this.userConfig.knockback));
                return true;
            }
        }
        return false;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void radius(double radius) {
        if (radius < 1.0 || radius > 8.0 || Math.abs(radius - this.radius) < 0.001) {
            return;
        }
        this.radius = radius;
        this.cleanAll();
        this.ring.clear();
        this.ring.addAll(WorldUtil.createBlockRing(this.user.eyeBlock(), this.radius));
    }

    private void cleanAll() {
        this.ring.stream().filter(MaterialUtil::isWater).forEach(TempBlock.air()::build);
    }

    @Override
    public void onDestroy() {
        this.destroyed = true;
        if (!this.completed) {
            this.cleanAll();
        }
    }

    public static @Nullable WaterRing getOrCreateInstance(User user) {
        Ability newRing;
        WaterRing oldRing;
        if (ringDesc == null) {
            ringDesc = Objects.requireNonNull(Registries.ABILITIES.fromString("WaterRing"));
        }
        if ((oldRing = (WaterRing)user.game().abilityManager(user.worldKey()).firstInstance(user, WaterRing.class).orElse(null)) == null && (newRing = user.game().activationController().activateAbility(user, Activation.ATTACK, ringDesc)) != null) {
            return (WaterRing)newRing;
        }
        return oldRing;
    }

    private void launchShard() {
        if (this.ring.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time >= this.nextShardTime) {
            this.nextShardTime = time + this.userConfig.shardCooldown;
            Vector3d origin = this.getClosestRingBlock().toVector3d();
            Vector3d lookingDir = (Vector3d)this.user.direction().multiply(this.userConfig.shardRange + this.radius);
            this.shards.add(new IceShard(Ray.of(origin, lookingDir)));
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.DURATION)
        private long duration = 30000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 16.0;
        private boolean affectEntities = true;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.0;
        @Modifiable(value=Attribute.COOLDOWN)
        private long shardCooldown = 1000L;
        @Modifiable(value=Attribute.RANGE)
        private double shardRange = 16.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double shardDamage = 0.25;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long waveChargeTime = 750L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "waterring");
        }
    }

    private class IceShard
    extends ParticleStream {
        public IceShard(Ray ray) {
            super(WaterRing.this.user, ray, 0.3, 0.5);
            this.canCollide = BlockProperties::isLiquid;
            this.steps = 5;
        }

        @Override
        public void render(Vector3d location) {
            Particle.ITEM_SNOWBALL.builder(location).count(3).offset(0.25).spawn(WaterRing.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.ICE.play(WaterRing.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(WaterRing.this.userConfig.shardDamage, WaterRing.this.user, WaterRing.this.description());
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            return WorldUtil.tryCoolLava(WaterRing.this.user, block);
        }
    }
}

