/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water.passive;

import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;

public class FastSwim
extends AbilityInstance {
    private RemovalPolicy removalPolicy;

    public FastSwim(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.removalPolicy = Policies.builder().add(Policies.PARTIALLY_UNDER_WATER.negate()).add(Policies.FLYING).build();
        return true;
    }

    @Override
    public void loadConfig() {
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.user.canBend(this.description())) {
            this.onDestroy();
            return Updatable.UpdateResult.CONTINUE;
        }
        EntityUtil.tryAddPotion(this.user, PotionEffect.DOLPHINS_GRACE, 100, 0);
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        EntityUtil.tryRemovePotion(this.user, PotionEffect.DOLPHINS_GRACE, 100, 0);
    }
}

