/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water.passive;

import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.Vector3d;

public class HydroSink
extends AbilityInstance {
    public HydroSink(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        return true;
    }

    @Override
    public void loadConfig() {
    }

    @Override
    public Updatable.UpdateResult update() {
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean canHydroSink() {
        if (!this.user.canBend(this.description())) {
            return false;
        }
        AABB entityBounds = this.user.bounds().grow(Vector3d.of(0.0, 0.2, 0.0));
        AABB floorBounds = AABB.of(Vector3d.of(-1.0, -0.5, -1.0), Vector3d.of(1.0, 0.0, 1.0)).at(this.user.location());
        return this.user.world().nearbyBlocks(floorBounds, b -> entityBounds.intersects(b.bounds())).stream().anyMatch(WaterMaterials::isWaterBendable);
    }

    public static boolean canHydroSink(User user) {
        return user.game().abilityManager(user.worldKey()).firstInstance(user, HydroSink.class).map(HydroSink::canHydroSink).orElse(false);
    }
}

