/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.TravellingSource;
import me.moros.bending.api.ability.common.basic.BlockStream;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.ability.water.Torrent;
import me.moros.bending.common.ability.water.WaterRing;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class WaterGimbal
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private boolean launched = false;

    public WaterGimbal(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, WaterGimbal.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        WaterRing ring = user.game().abilityManager(user.worldKey()).firstInstance(user, WaterRing.class).orElse(null);
        ArrayList<Block> sources = new ArrayList<Block>();
        if (ring != null && ring.isReady()) {
            sources.addAll(ring.complete());
        }
        if (sources.isEmpty()) {
            Block source = user.find(this.userConfig.selectRange, WaterMaterials::isFullWaterSource);
            if (source == null) {
                return false;
            }
            sources.add(source);
            this.states = new StateChain(sources).addState(new TravellingSource(user, BlockType.WATER.defaultState(), 3.5, this.userConfig.selectRange + 5.0));
        } else {
            this.states = new StateChain(sources);
        }
        this.states.addState(new Gimbal(user)).addState(new GimbalStream()).start();
        AbilityDescription torrentDesc = user.selectedAbility();
        if (torrentDesc == null) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(ExpireRemovalPolicy.of(30000L)).add(SwappedSlotsRemovalPolicy.of(torrentDesc)).build();
        user.game().abilityManager(user.worldKey()).destroyUserInstances(user, List.of(Torrent.class, WaterRing.class));
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.states.update();
    }

    public static void launch(User user) {
        if (user.hasAbilitySelected("torrent")) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, WaterGimbal.class).ifPresent(WaterGimbal::launch);
        }
    }

    private void launch() {
        if (this.launched) {
            return;
        }
        State state = this.states.current();
        if (state instanceof Gimbal) {
            this.launched = true;
            this.removalPolicy = Policies.defaults();
            state.complete();
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    @Override
    public void onDestroy() {
        State current = this.states.current();
        if (current instanceof GimbalStream) {
            GimbalStream gimbalStream = (GimbalStream)current;
            gimbalStream.cleanAll();
        }
    }

    @Override
    public Collection<Collider> colliders() {
        Collection<Collider> collection;
        State state = this.states.current();
        if (state instanceof GimbalStream) {
            GimbalStream gimbalStream = (GimbalStream)state;
            collection = gimbalStream.colliders();
        } else {
            collection = List.of();
        }
        return collection;
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 10000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 8.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 24.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 6.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.2;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.25;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "sequences", "watergimbal");
        }
    }

    private static final class Gimbal
    implements State {
        private final User user;
        private StateChain chain;
        private Block center;
        private boolean started = false;
        private int angle = 0;

        private Gimbal(User user) {
            this.user = user;
        }

        @Override
        public void start(StateChain chain) {
            if (this.started) {
                return;
            }
            this.chain = chain;
            this.started = !chain.chainStore().isEmpty();
        }

        @Override
        public void complete() {
            if (!this.started) {
                return;
            }
            if (this.center == null) {
                this.center = this.user.world().blockAt((Position)((Vector3d)this.user.location().add(Vector3d.PLUS_J)).add((Position)((Vector3d)this.user.direction().withY(0.0)).multiply(2.0)));
                TempBlock.water().duration(50L).build(this.center);
            }
            this.chain.chainStore().clear();
            this.chain.chainStore().addAll(Collections.nCopies(10, this.center));
            this.chain.nextState();
        }

        @Override
        public Updatable.UpdateResult update() {
            if (!this.started) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (!this.user.canBuild()) {
                return Updatable.UpdateResult.REMOVE;
            }
            HashSet<Block> ring = new HashSet<Block>();
            double yaw = Math.toRadians(-this.user.yaw()) - 1.5707963267948966;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            Vector3d center = (Vector3d)this.user.location().add(Vector3d.PLUS_J);
            for (int i = 0; i < 2; ++i) {
                Vector3d v1;
                double theta = Math.toRadians(this.angle);
                this.angle += 18;
                if (this.angle >= 360) {
                    this.angle = 0;
                }
                Vector3d v2 = v1 = (Vector3d)Vector3d.of(Math.cos(theta), Math.sin(theta), 0.0).multiply(3.4);
                v1 = VectorUtil.rotateAroundAxisX(v1, 0.7, 0.7);
                v1 = VectorUtil.rotateAroundAxisY(v1, cos, sin);
                v2 = VectorUtil.rotateAroundAxisX(v2, 0.7, -0.7);
                v2 = VectorUtil.rotateAroundAxisY(v2, cos, sin);
                Block block1 = this.user.world().blockAt((Position)center.add(v1));
                Block block2 = this.user.world().blockAt((Position)center.add(v2));
                if (!ring.contains(block1)) {
                    this.addValidBlock(block1, ring);
                }
                if (ring.contains(block2)) continue;
                this.addValidBlock(block2, ring);
            }
            ring.forEach(this::render);
            return Updatable.UpdateResult.CONTINUE;
        }

        private void render(Block block) {
            if (MaterialUtil.isWater(block)) {
                ParticleBuilder.bubble(block).spawn(this.user.world());
            } else if (MaterialUtil.isTransparent(block)) {
                TempBlock.water().duration(150L).build(block);
            }
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                SoundEffect.WATER.play(block);
            }
        }

        private void addValidBlock(Block start, Collection<Block> ring) {
            for (int i = 0; i < 4; ++i) {
                Block block = start.offset(Direction.UP, i);
                if (!MaterialUtil.isTransparentOrWater(block)) continue;
                this.center = block;
                ring.add(block);
                return;
            }
        }
    }

    private class GimbalStream
    extends BlockStream {
        private final Set<UUID> affectedEntities;

        public GimbalStream() {
            super(WaterGimbal.this.user, BlockType.WATER, WaterGimbal.this.userConfig.range, 16);
            this.affectedEntities = new HashSet<UUID>();
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (entity instanceof LivingEntity && this.affectedEntities.add(entity.uuid())) {
                entity.damage(WaterGimbal.this.userConfig.damage, WaterGimbal.this.user, WaterGimbal.this.description());
                Vector3d velocity = (Vector3d)((Vector3d)this.direction.withY(Math.min(this.direction.y(), WaterGimbal.this.userConfig.knockup))).multiply(WaterGimbal.this.userConfig.knockback);
                entity.applyVelocity(WaterGimbal.this, velocity);
            }
            return false;
        }

        @Override
        protected void renderHead(Block block) {
            Particle.ITEM_SNOWBALL.builder(block.center()).count(6).offset(0.25).extra(0.05).spawn(WaterGimbal.this.user.world());
            if (!MaterialUtil.isWater(block)) {
                TempBlock.water().build(block);
            }
        }

        @Override
        public void postRender() {
            Block head;
            if (ThreadLocalRandom.current().nextInt(5) == 0 && (head = (Block)this.stream.peekFirst()) != null) {
                SoundEffect.WATER.play(head);
            }
        }

        @Override
        public void onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, 3, Ray.of(block.center(), this.direction));
        }
    }
}

