/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.moros.bending.api.adapter.PacketUtil;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.display.Display;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.common.adapter.DisplayUtil;
import me.moros.bending.common.adapter.EntityDataBuilder;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.minecraft.class_10182;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_2062;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2620;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2716;
import net.minecraft.class_2743;
import net.minecraft.class_2777;
import net.minecraft.class_2779;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_8042;
import net.minecraft.class_8779;
import net.minecraft.class_8782;

public abstract class AbstractPacketUtil
implements PacketUtil {
    private final class_3324 playerList;
    private static final class_2960 ADVANCEMENT_KEY = class_2960.method_60655((String)"bending", (String)"notification");

    protected AbstractPacketUtil(class_3324 playerList) {
        this.playerList = playerList;
    }

    protected class_3324 playerList() {
        return this.playerList;
    }

    protected abstract class_3218 adapt(World var1);

    protected abstract class_2680 adapt(BlockState var1);

    protected abstract class_1297 adapt(Entity var1);

    protected abstract class_1799 adapt(Item var1);

    protected abstract class_2561 adapt(Component var1);

    protected abstract int nextEntityId();

    @Override
    public PacketUtil.ClientboundPacket createNotification(Item item, Component title) {
        return this.wrap((class_2596<?>)new class_8042(List.of(this.createNotificationPacket(item, title), this.clearNotification())));
    }

    @Override
    public PacketUtil.ClientboundPacket fakeBlock(Position position, BlockState state) {
        return this.wrap((class_2596<?>)this.fakeBlockPacket(position, this.adapt(state)));
    }

    @Override
    public PacketUtil.ClientboundPacket fakeBreak(Position position, byte progress) {
        return this.wrap((class_2596<?>)this.fakeBreakPacket(position, progress));
    }

    @Override
    public PacketUtil.ClientboundPacket createFallingBlock(Position center, BlockState state, Vector3d velocity, boolean gravity) {
        int id = this.nextEntityId();
        ArrayList<Object> packets = new ArrayList<Object>();
        int blockDataId = class_2248.method_9507((class_2680)this.adapt(state));
        packets.add(this.createEntity(id, center, class_1299.field_6089, blockDataId));
        if (!gravity) {
            packets.add(new EntityDataBuilder(id).noGravity().build());
        }
        if (velocity.lengthSq() > 0.0) {
            packets.add(this.addVelocity(id, velocity));
        }
        return this.wrap(id, (class_2596<?>)new class_8042(packets));
    }

    @Override
    public PacketUtil.ClientboundPacket createDisplayEntity(Position center, Display<?> properties) {
        int id = this.nextEntityId();
        EntityDataBuilder builder = new EntityDataBuilder(id);
        class_1299<?> type = DisplayUtil.mapProperties(this, builder, properties);
        return this.wrap(id, (class_2596<?>)new class_8042(List.of(this.createEntity(id, center, type, 0), builder.build())));
    }

    @Override
    public PacketUtil.ClientboundPacket updateDisplayPosition(int id, Vector3d position) {
        return this.wrap(id, (class_2596<?>)this.teleportEntity(id, position));
    }

    @Override
    public void destroy(int[] ids) {
        class_2716 packet = new class_2716(ids);
        this.playerList().method_14571().forEach(p -> p.field_13987.method_14364((class_2596)packet));
    }

    protected class_2779 createNotificationPacket(Item item, Component title) {
        String criteriaId = "bending:criteria_progress";
        class_1799 icon = this.adapt(item);
        class_2561 nmsTitle = this.adapt(title);
        class_5250 nmsDesc = class_2561.method_43473();
        class_189 type = class_189.field_1254;
        class_175 criterion = class_174.field_1184.method_53699((class_184)new class_2062.class_2063());
        class_8779 advancement = new class_161.class_162().method_20416(icon, nmsTitle, (class_2561)nmsDesc, null, type, true, false, true).method_705(criteriaId, criterion).method_695(ADVANCEMENT_KEY);
        class_167 progress = new class_167();
        progress.method_727(class_8782.method_53668(List.of(criteriaId)));
        progress.method_743(criteriaId);
        Map<class_2960, class_167> progressMap = Map.of(ADVANCEMENT_KEY, progress);
        return new class_2779(false, List.of(advancement), Set.of(), progressMap, true);
    }

    protected class_2779 clearNotification() {
        return new class_2779(false, List.of(), Set.of(ADVANCEMENT_KEY), Map.of(), true);
    }

    protected class_2604 createEntity(int id, Position center, class_1299<?> type, int data) {
        double x = center.x();
        double y = center.y();
        double z = center.z();
        return new class_2604(id, UUID.randomUUID(), x, y, z, 0.0f, 0.0f, type, data, class_243.field_1353, 0.0);
    }

    protected class_2743 addVelocity(int id, Vector3d vel) {
        return new class_2743(id, new class_243(vel.x(), vel.y(), vel.z()));
    }

    protected class_2626 fakeBlockPacket(Position b, class_2680 state) {
        return new class_2626(new class_2338(b.blockX(), b.blockY(), b.blockZ()), state);
    }

    protected class_2620 fakeBreakPacket(Position b, byte progress) {
        int id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        return new class_2620(id, new class_2338(b.blockX(), b.blockY(), b.blockZ()), (int)progress);
    }

    protected class_2777 teleportEntity(int id, Position position) {
        class_243 vec3 = new class_243(position.x(), position.y(), position.z());
        class_10182 positionMoveRotation = new class_10182(vec3, class_243.field_1353, 0.0f, 0.0f);
        return class_2777.method_64565((int)id, (class_10182)positionMoveRotation, Set.of(), (boolean)false);
    }

    protected PacketUtil.ClientboundPacket wrap(class_2596<?> packet) {
        return new PacketWrapper(packet);
    }

    protected PacketUtil.ClientboundPacket wrap(int id, class_2596<?> packet) {
        return new PacketWrapper(id, packet);
    }

    private final class PacketWrapper<T extends class_2547>
    implements PacketUtil.ClientboundPacket {
        private final int id;
        private final class_2596<T> packet;

        private PacketWrapper(int id, class_2596<T> packet) {
            this.id = id;
            this.packet = packet;
        }

        private PacketWrapper(class_2596<T> packet) {
            this(0, packet);
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public void send(Iterable<UUID> playerUUIDs) {
            for (UUID uuid : playerUUIDs) {
                class_3222 player = AbstractPacketUtil.this.playerList().method_14602(uuid);
                if (player == null) continue;
                player.field_13987.method_14364(this.packet);
            }
        }

        @Override
        public void broadcast(World world, Position center, int dist) {
            this.forEachPlayer(world, center, dist, p -> p.field_13987.method_14364(this.packet));
        }

        private void forEachPlayer(World world, Position center, int dist, Consumer<class_3222> playerConsumer) {
            int distanceSq = dist * dist;
            for (class_3222 player : AbstractPacketUtil.this.adapt(world).method_18456()) {
                if (!(Vector3d.of(player.method_23317(), player.method_23318(), player.method_23321()).distanceSq(center) <= (double)distanceSq)) continue;
                playerConsumer.accept(player);
            }
        }
    }
}

