/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import me.moros.bending.common.adapter.EntityMeta;
import net.minecraft.class_2739;
import net.minecraft.class_2941;
import net.minecraft.class_2945;

final class EntityDataBuilder {
    private final int id;
    private final Collection<class_2945.class_7834<?>> dataValues;
    private byte statusFlags;

    EntityDataBuilder(int id) {
        this.id = id;
        this.dataValues = new TreeSet<class_2945.class_7834>(Comparator.comparingInt(class_2945.class_7834::comp_1115));
        this.statusFlags = 0;
    }

    <T> EntityDataBuilder setRaw(int index, class_2941<T> serializer, T data) {
        this.dataValues.add(new class_2945.class_7834(index, serializer, data));
        return this;
    }

    <T> EntityDataBuilder setRaw(EntityMeta<T> key, T data) {
        return this.setRaw(key.index(), key.serializer(), data);
    }

    EntityDataBuilder noGravity() {
        return this.setRaw(EntityMeta.GRAVITY, true);
    }

    EntityDataBuilder withStatus(EntityMeta.EntityStatus status) {
        this.statusFlags = (byte)(this.statusFlags | 1 << status.index());
        this.setRaw(EntityMeta.ENTITY_STATUS, this.statusFlags);
        return this;
    }

    class_2739 build() {
        return new class_2739(this.id, List.copyOf(this.dataValues));
    }
}

