/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ObjIntConsumer;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.user.User;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_270;
import net.minecraft.class_2736;
import net.minecraft.class_274;
import net.minecraft.class_2751;
import net.minecraft.class_2757;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_5900;
import net.minecraft.class_8042;
import net.minecraft.class_8646;
import net.minecraft.class_8824;
import net.minecraft.class_9006;
import net.minecraft.class_9020;
import net.minecraft.class_9024;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Sidebar
implements Board {
    private static final Component ACTIVE = Component.text((String)"> ");
    private static final Component INACTIVE = Component.text((String)"> ", (TextColor)NamedTextColor.DARK_GRAY);
    private static final Component SEP = Component.text((String)" -------------- ");
    private static final String OBJECTIVE_ID = "bending-board";
    private static final String[] CHAT_CODES = new String[16];
    private final MinecraftServer server;
    private final User user;
    private final Map<AbilityDescription, IndexedScore> misc;
    private int selectedSlot;
    private boolean closed;

    private static String generateInvisibleLegacyString(int slot) {
        String hidden = CHAT_CODES[slot % CHAT_CODES.length];
        int delta = slot - CHAT_CODES.length;
        return delta <= 0 ? hidden + String.valueOf(class_124.field_1070) : hidden + Sidebar.generateInvisibleLegacyString(delta);
    }

    protected Sidebar(MinecraftServer server, User user) {
        this.server = server;
        this.user = user;
        this.misc = new ConcurrentHashMap<AbilityDescription, IndexedScore>();
        this.selectedSlot = user.currentSlot();
    }

    protected void init(Component title) {
        this.trySendPackets(this.createInitialPacket(title));
    }

    private List<class_2596<? super class_2602>> createInitialPacket(Component title) {
        ArrayList<class_2596<? super class_2602>> packets = new ArrayList<class_2596<? super class_2602>>(11);
        packets.addAll(this.buildInitialPackets(title));
        this.forEachSlotScore((score, slot) -> packets.addAll(this.createScore(slot, (Score)score)));
        return packets;
    }

    protected abstract Component emptySlot(int var1);

    protected abstract class_2561 toNative(Component var1);

    @Override
    public boolean isEnabled() {
        return !this.closed;
    }

    @Override
    public void disableScoreboard() {
        if (!this.closed) {
            ArrayList<class_2596<? super class_2602>> packets = new ArrayList<class_2596<? super class_2602>>();
            for (int slot = 1; slot <= 9; ++slot) {
                packets.add((class_2596<? super class_2602>)this.buildTeamPacket(slot, TeamAction.REMOVE, Score.EMPTY));
            }
            this.misc.values().forEach(indexed -> packets.add((class_2596<? super class_2602>)this.buildTeamPacket(indexed.index(), TeamAction.REMOVE, Score.EMPTY)));
            packets.add((class_2596<? super class_2602>)this.buildRemoveObjectivePacket());
            this.trySendPackets(packets);
            this.closed = true;
        }
    }

    @Override
    public void updateAll() {
        ArrayList<class_2596<? super class_2602>> packets = new ArrayList<class_2596<? super class_2602>>();
        this.forEachSlotScore((score, slot) -> packets.add((class_2596<? super class_2602>)this.updateScore(slot, (Score)score)));
        this.trySendPackets(packets);
    }

    private Score getScoreForSlot(int slot, @Nullable AbilityDescription desc) {
        Component prefix;
        Component component = prefix = slot == this.selectedSlot ? ACTIVE : INACTIVE;
        Component suffix = desc == null ? this.emptySlot(slot) : (!this.user.onCooldown(desc) ? desc.displayName() : desc.displayName().decorate(TextDecoration.STRIKETHROUGH));
        return new Score(prefix, suffix);
    }

    private void forEachSlotScore(ObjIntConsumer<Score> consumer) {
        List<AbilityDescription> snapshot = this.user.slots().abilities();
        for (int slot = 1; slot <= 9; ++slot) {
            consumer.accept(this.getScoreForSlot(slot, snapshot.get(slot - 1)), slot);
        }
    }

    @Override
    public void activeSlot(int oldSlot, int newSlot) {
        if (this.validSlot(oldSlot) && this.validSlot(newSlot)) {
            if (this.selectedSlot != oldSlot) {
                oldSlot = this.selectedSlot;
            }
            this.selectedSlot = newSlot;
            List<class_5900> packets = List.of(this.updateScore(oldSlot, this.getScoreForSlot(oldSlot, this.user.boundAbility(oldSlot))), this.updateScore(newSlot, this.getScoreForSlot(newSlot, this.user.boundAbility(newSlot))));
            this.trySendPackets(packets);
        }
    }

    private boolean validSlot(int slot) {
        return 1 <= slot && slot <= 9;
    }

    @Override
    public void updateMisc(AbilityDescription desc, boolean show) {
        ArrayList<class_2596<? super class_2602>> packets = new ArrayList<class_2596<? super class_2602>>();
        if (show) {
            if (this.misc.isEmpty()) {
                packets.addAll(this.createScore(10, new Score(SEP)));
            }
            Component miscName = INACTIVE.append(desc.displayName().decorate(TextDecoration.STRIKETHROUGH));
            IndexedScore indexed = new IndexedScore(this.pickAvailableSlot(), new Score(miscName));
            if (this.misc.putIfAbsent(desc, indexed) == null) {
                packets.addAll(this.createScore(indexed.index(), indexed.scoreEntry()));
            }
        } else {
            IndexedScore old = this.misc.remove(desc);
            if (old != null) {
                packets.addAll(this.removeScore(old.index()));
                if (this.misc.isEmpty()) {
                    packets.addAll(this.removeScore(10));
                }
            }
        }
        this.trySendPackets(packets);
    }

    private int pickAvailableSlot() {
        int idx = 11;
        for (IndexedScore indexedTeam : this.misc.values()) {
            idx = Math.max(indexedTeam.index() + 1, idx);
        }
        return idx;
    }

    private class_2540 createByteBuf() {
        return new class_2540(Unpooled.buffer());
    }

    private class_9129 createRegistryFriendlyByteBuf() {
        return new class_9129((ByteBuf)this.createByteBuf(), (class_5455)this.server.method_30611());
    }

    private List<class_2596<? super class_2602>> buildInitialPackets(Component title) {
        return List.of(this.buildCreateObjectivePacket(title), this.buildSetDisplayObjectivePacket());
    }

    private class_2751 buildCreateObjectivePacket(Component title) {
        class_9129 buf = this.createRegistryFriendlyByteBuf();
        buf.method_10814(OBJECTIVE_ID);
        buf.method_52997(0);
        class_8824.field_49666.encode((Object)buf, (Object)this.toNative(title));
        buf.method_10817((Enum)class_274.class_275.field_1472);
        class_9024.field_48545.encode((Object)buf, Optional.of(class_9020.field_47557));
        return (class_2751)class_2751.field_47985.decode((Object)buf);
    }

    private class_2751 buildRemoveObjectivePacket() {
        class_9129 buf = this.createRegistryFriendlyByteBuf();
        buf.method_10814(OBJECTIVE_ID);
        buf.method_52997(1);
        return (class_2751)class_2751.field_47985.decode((Object)buf);
    }

    private class_2736 buildSetDisplayObjectivePacket() {
        class_2540 buf = this.createByteBuf();
        buf.method_52963(class_8646::method_52621, (Object)class_8646.field_45157);
        buf.method_10814(OBJECTIVE_ID);
        return (class_2736)class_2736.field_47978.decode((Object)buf);
    }

    private List<class_2596<? super class_2602>> createScore(int score, Score scoreEntry) {
        String objName = Sidebar.generateInvisibleLegacyString(score);
        return List.of(new class_2757(objName, OBJECTIVE_ID, -score, Optional.empty(), Optional.empty()), this.buildTeamPacket(score, TeamAction.CREATE, scoreEntry));
    }

    private List<class_2596<? super class_2602>> removeScore(int score) {
        String objName = Sidebar.generateInvisibleLegacyString(score);
        return List.of(this.buildTeamPacket(score, TeamAction.REMOVE, Score.EMPTY), new class_9006(objName, OBJECTIVE_ID));
    }

    private class_5900 updateScore(int score, Score scoreEntry) {
        return this.buildTeamPacket(score, TeamAction.UPDATE, scoreEntry);
    }

    private class_5900 buildTeamPacket(int score, TeamAction action, Score scoreEntry) {
        class_9129 buf = this.createRegistryFriendlyByteBuf();
        buf.method_10814(String.valueOf(score));
        buf.method_52997(action.method);
        if (action != TeamAction.REMOVE) {
            class_8824.field_49666.encode((Object)buf, (Object)class_2561.method_43470((String)String.valueOf(score)));
            buf.method_52997(0);
            class_270.class_272.field_56490.encode((Object)buf, (Object)class_270.class_272.field_1442);
            class_270.class_271.field_56487.encode((Object)buf, (Object)class_270.class_271.field_1437);
            buf.method_10817((Enum)class_124.field_1070);
            class_8824.field_49666.encode((Object)buf, (Object)this.toNative(scoreEntry.prefix()));
            class_8824.field_49666.encode((Object)buf, (Object)this.toNative(scoreEntry.suffix()));
            if (action == TeamAction.CREATE) {
                buf.method_34062(List.of(Sidebar.generateInvisibleLegacyString(score)), class_2540::method_10814);
            }
        }
        return (class_5900)class_5900.field_47987.decode((Object)buf);
    }

    private void trySendPackets(SequencedCollection<class_2596<? super class_2602>> packets) {
        if (!this.closed && !packets.isEmpty()) {
            class_8042 packet = packets.size() == 1 ? packets.getFirst() : new class_8042(packets);
            class_3222 player = this.server.method_3760().method_14602(this.user.uuid());
            if (player != null) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    static {
        char prefix = '\u00a7';
        for (int i = 0; i < CHAT_CODES.length; ++i) {
            Sidebar.CHAT_CODES[i] = prefix + Integer.toHexString(i);
        }
    }

    private static enum TeamAction {
        CREATE(0),
        REMOVE(1),
        UPDATE(2);

        private final int method;

        private TeamAction(int method) {
            this.method = method;
        }
    }

    private record Score(Component prefix, Component suffix) {
        private static final Score EMPTY = new Score((Component)Component.empty(), (Component)Component.empty());

        public Score(Component prefix) {
            this(prefix, (Component)Component.empty());
        }
    }

    private record IndexedScore(int index, Score scoreEntry) {
    }
}

